/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.response;

import java.util.HashSet;
import java.util.Set;
import org.jolokia.client.exception.JolokiaRemoteException;
import org.jolokia.client.request.JolokiaRequest;
import org.jolokia.client.response.JolokiaResponse;
import org.jolokia.client.response.JolokiaResponseExtractor;
import org.jolokia.json.JSONObject;

public class ValidatingResponseExtractor
implements JolokiaResponseExtractor {
    public static final ValidatingResponseExtractor DEFAULT = new ValidatingResponseExtractor(new int[0]);
    public static final ValidatingResponseExtractor OPTIONAL = new ValidatingResponseExtractor(404);
    Set<Integer> allowedCodes = new HashSet<Integer>();

    public ValidatingResponseExtractor(int ... pCodesAllowed) {
        this.allowedCodes.add(200);
        for (int code : pCodesAllowed) {
            this.allowedCodes.add(code);
        }
    }

    @Override
    public <RESP extends JolokiaResponse<REQ>, REQ extends JolokiaRequest> RESP extract(REQ pRequest, JSONObject pJsonResp, boolean includeRequest) throws JolokiaRemoteException {
        Object o;
        int status = 0;
        if (pJsonResp.containsKey((Object)"status") && (o = pJsonResp.get((Object)"status")) instanceof Number) {
            Number n = (Number)o;
            status = n.intValue();
        }
        if (!this.allowedCodes.contains(status)) {
            throw new JolokiaRemoteException(pRequest, pJsonResp);
        }
        if (status == 200) {
            Object response = pRequest.createResponse(pJsonResp);
            if (!includeRequest) {
                ((JolokiaResponse)response).clearRequest();
            }
            return (RESP)response;
        }
        return null;
    }
}

