/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.response;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.client.request.JolokiaReadRequest;
import org.jolokia.client.response.JolokiaResponse;
import org.jolokia.json.JSONObject;

public final class JolokiaReadResponse
extends JolokiaResponse<JolokiaReadRequest> {
    public JolokiaReadResponse(JolokiaReadRequest pRequest, JSONObject pJsonResponse) {
        super(pRequest, pJsonResponse);
    }

    public Collection<ObjectName> getObjectNames() throws MalformedObjectNameException {
        ObjectName mBean = ((JolokiaReadRequest)this.getRequest()).getObjectName();
        if (mBean.isPattern()) {
            JSONObject values = (JSONObject)this.getValue();
            HashSet<ObjectName> ret = new HashSet<ObjectName>();
            for (String name : values.keySet()) {
                ret.add(new ObjectName(name));
            }
            return ret;
        }
        return List.of(mBean);
    }

    public Collection<String> getAttributes(ObjectName pObjectName) {
        ObjectName requestMBean = ((JolokiaReadRequest)this.getRequest()).getObjectName();
        if (requestMBean.isPattern()) {
            JSONObject attributes = this.getAttributesForObjectNameWithPatternRequest(pObjectName);
            return attributes.keySet();
        }
        if (pObjectName != null && !pObjectName.equals(requestMBean)) {
            throw new IllegalArgumentException("Given ObjectName " + String.valueOf(pObjectName) + " doesn't match with the single ObjectName " + String.valueOf(requestMBean) + " given in the request");
        }
        return this.getAttributes();
    }

    public Collection<String> getAttributes() {
        JolokiaReadRequest request = (JolokiaReadRequest)this.getRequest();
        ObjectName requestBean = request.getObjectName();
        if (requestBean.isPattern()) {
            throw new IllegalArgumentException("Attributes can be fetched only for non-pattern request (current: " + requestBean.getCanonicalName() + ")");
        }
        if (request.hasSingleAttribute()) {
            return request.getAttributes();
        }
        JSONObject attributes = (JSONObject)this.getValue();
        return attributes.keySet();
    }

    public <V> V getValue(ObjectName pObjectName, String pAttribute) {
        ObjectName requestMBean = ((JolokiaReadRequest)this.getRequest()).getObjectName();
        if (requestMBean.isPattern()) {
            JSONObject mAttributes = this.getAttributesForObjectNameWithPatternRequest(pObjectName);
            if (!mAttributes.containsKey((Object)pAttribute)) {
                throw new IllegalArgumentException("No attribute " + pAttribute + " for ObjectName " + String.valueOf(pObjectName) + " returned for the given request");
            }
            return (V)mAttributes.get((Object)pAttribute);
        }
        return this.getValue(pAttribute);
    }

    public <V> V getValue(String pAttribute) {
        JolokiaReadRequest request = (JolokiaReadRequest)this.getRequest();
        ObjectName requestBean = request.getObjectName();
        if (requestBean.isPattern()) {
            throw new IllegalArgumentException("Attributes without ObjectName can be fetched only for non-pattern request (current: " + requestBean.getCanonicalName() + ")");
        }
        if (request.hasSingleAttribute()) {
            if (pAttribute != null && !pAttribute.equals(request.getAttribute())) {
                throw new IllegalArgumentException("Given attribute " + pAttribute + " doesnt match single attribute given " + request.getAttribute() + " in the request");
            }
            return this.getValue();
        }
        JSONObject attributes = (JSONObject)this.getValue();
        if (pAttribute == null) {
            throw new IllegalArgumentException("Cannot use null-attribute name to fetch a value from a multi-attribute request");
        }
        if (!attributes.containsKey((Object)pAttribute)) {
            throw new IllegalArgumentException("No such key " + pAttribute + " in the set of returned attribute values");
        }
        return (V)attributes.get((Object)pAttribute);
    }

    private JSONObject getAttributesForObjectNameWithPatternRequest(ObjectName pObjectName) {
        if (pObjectName == null) {
            try {
                pObjectName = new ObjectName("*:*");
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                // empty catch block
            }
        }
        ObjectName pMBeanFromRequest = ((JolokiaReadRequest)this.getRequest()).getObjectName();
        ObjectName objectName = pObjectName == null ? pMBeanFromRequest : pObjectName;
        JSONObject values = (JSONObject)this.getValue();
        JSONObject attributes = (JSONObject)values.get((Object)objectName.getCanonicalName());
        if (attributes == null) {
            throw new IllegalArgumentException("No ObjectName " + String.valueOf(objectName) + " found in the set of returned  ObjectNames for requested pattern " + String.valueOf(pMBeanFromRequest));
        }
        return attributes;
    }
}

