/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EscapeUtil {
    private static final Pattern SLASH_ESCAPE_PATTERN = Pattern.compile("((?:[^!/]|!.)*)(?:/|$)");
    private static final Pattern UNESCAPE_PATTERN = Pattern.compile("!(.)");

    public static List<String> splitPath(String pArg) {
        ArrayList<String> ret = new ArrayList<String>();
        if (pArg != null) {
            Matcher m = SLASH_ESCAPE_PATTERN.matcher(pArg);
            while (m.find() && m.start(1) != pArg.length()) {
                ret.add(UNESCAPE_PATTERN.matcher(m.group(1)).replaceAll("$1"));
            }
        }
        return ret;
    }

    public static String combinePath(List<String> pathElements) {
        if (pathElements != null && !pathElements.isEmpty()) {
            StringBuilder path = new StringBuilder();
            for (int i = 0; i < pathElements.size(); ++i) {
                if (pathElements.get(i) == null) continue;
                path.append(EscapeUtil.escape(pathElements.get(i)));
                if (i >= pathElements.size() - 1) continue;
                path.append("/");
            }
            return path.toString();
        }
        return null;
    }

    public static String escape(String pValue) {
        return pValue.replaceAll("!", "!!").replaceAll("/", "!/");
    }
}

