/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.response;

import java.time.Instant;
import org.jolokia.client.JolokiaOperation;
import org.jolokia.client.request.JolokiaRequest;
import org.jolokia.json.JSONObject;

public abstract class JolokiaResponse<T extends JolokiaRequest> {
    private final JSONObject jsonResponse;
    private final JolokiaOperation requestType;
    private T request;
    private final Instant responseTimestamp;

    protected JolokiaResponse(T pRequest, JSONObject pJsonResponse) {
        Instant instant;
        this.request = pRequest;
        this.requestType = ((JolokiaRequest)pRequest).getType();
        this.jsonResponse = pJsonResponse;
        Object ts = this.jsonResponse.get((Object)"timestamp");
        if (ts instanceof Number) {
            Number timestamp = (Number)ts;
            instant = Instant.ofEpochSecond(timestamp.longValue());
        } else {
            instant = Instant.now();
        }
        this.responseTimestamp = instant;
    }

    public T getRequest() {
        return this.request;
    }

    public void clearRequest() {
        this.request = null;
    }

    public JolokiaOperation getType() {
        return this.requestType;
    }

    public Instant getResponseTimestamp() {
        return this.responseTimestamp;
    }

    public <V> V getValue() {
        return (V)this.jsonResponse.get((Object)"value");
    }

    public <V> V getValue(Class<V> clazz) {
        Object value = this.jsonResponse.get((Object)"value");
        return clazz.isAssignableFrom(value.getClass()) ? (V)clazz.cast(value) : null;
    }

    public JSONObject asJSONObject() {
        return this.jsonResponse;
    }
}

