/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.notif.pull;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.management.Notification;
import org.jolokia.server.core.service.notification.NotificationResult;
import org.jolokia.server.core.service.notification.NotificationSubscription;

public class NotificationStore {
    private final int maxEntries;
    private final SortedSet<Notification> entries;
    private int dropped;
    private final NotificationSubscription subscription;

    public NotificationStore(NotificationSubscription pSubscription, int pMaxEntries) {
        this.subscription = pSubscription;
        this.entries = Collections.synchronizedSortedSet(new TreeSet<Notification>(this.getComparator()));
        this.maxEntries = pMaxEntries;
        this.dropped = 0;
    }

    synchronized void add(Notification pNotification) {
        if (this.entries.size() >= this.maxEntries) {
            this.entries.remove(this.entries.first());
            ++this.dropped;
        }
        this.entries.add(pNotification);
    }

    NotificationResult fetchAndClear() {
        ArrayList<Notification> notifs = new ArrayList<Notification>(this.entries);
        NotificationResult ret = new NotificationResult(this.subscription.getHandle(), notifs, this.subscription.getHandback(), this.dropped);
        this.entries.clear();
        this.subscription.ping();
        this.dropped = 0;
        return ret;
    }

    int getDropped() {
        return this.dropped;
    }

    private Comparator<? super Notification> getComparator() {
        return new Comparator<Notification>(){

            @Override
            public int compare(Notification o1, Notification o2) {
                return (int)(o1.getSequenceNumber() - o2.getSequenceNumber());
            }
        };
    }
}

