/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.util.NetworkUtil;
import org.jolokia.service.discovery.AbstractDiscoveryMessage;
import org.jolokia.service.discovery.DiscoveryIncomingMessage;
import org.jolokia.service.discovery.DiscoveryOutgoingMessage;
import org.jolokia.service.discovery.MulticastUtil;

class MulticastSocketListenerThread
extends Thread {
    private final JolokiaContext context;
    private final InetAddress bindAddress;
    private boolean running;
    private MulticastSocket socket;
    private String socketName;

    MulticastSocketListenerThread(String pHostAddress, JolokiaContext pContext) throws IOException {
        this.bindAddress = pHostAddress != null ? InetAddress.getByName(pHostAddress) : NetworkUtil.getAnyAddress();
        this.context = pContext;
        if (!this.bindAddress.isAnyLocalAddress()) {
            throw new IllegalArgumentException("MulticastSocketListenerThread can't bind UDP socket to " + pHostAddress + ". 0.0.0.0 or [::] has to be used.");
        }
        this.socket = MulticastUtil.newMulticastSocket(this.bindAddress, pContext);
        this.socketName = MulticastUtil.getReadableSocketName(this.socket);
        pContext.debug(this.socketName + " |-- Listening for queries");
        this.setName("JolokiaDiscoveryListenerThread-" + this.socket.getLocalAddress().getHostAddress() + ":" + this.socket.getLocalPort());
        this.setDaemon(true);
    }

    @Override
    public void run() {
        this.setRunning(true);
        try {
            while (this.isRunning()) {
                this.refreshSocket();
                DiscoveryIncomingMessage msg = this.receiveMessage();
                if (!this.shouldMessageBeProcessed(msg)) continue;
                this.handleQuery(msg);
            }
        }
        catch (IllegalStateException e) {
            this.context.error(this.socketName + " --- Can not reopen socket, exiting listener thread: " + e.getMessage(), e.getCause());
        }
        finally {
            if (this.socket != null) {
                this.socket.close();
            }
            this.context.debug(this.socketName + " --- Stop listening");
        }
    }

    private synchronized void setRunning(boolean pRunning) {
        this.running = pRunning;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void shutdown() {
        this.setRunning(false);
        this.interrupt();
        this.socket.close();
    }

    private boolean shouldMessageBeProcessed(DiscoveryIncomingMessage pMsg) {
        return pMsg != null && this.context.isRemoteAccessAllowed(pMsg.getSourceAddress().getHostAddress()) && pMsg.isQuery();
    }

    private DiscoveryIncomingMessage receiveMessage() {
        byte[] buf = new byte[8972];
        DatagramPacket packet = new DatagramPacket(buf, buf.length);
        try {
            packet.setLength(buf.length);
            this.socket.receive(packet);
            return new DiscoveryIncomingMessage(packet);
        }
        catch (IOException e) {
            if (!this.socket.isClosed()) {
                this.context.info(this.socketName + " <-- " + MulticastUtil.getReadableSocketName(packet.getAddress(), packet.getPort()) + " - Error while handling discovery request, ignoring: " + e.getMessage());
            }
            return null;
        }
    }

    private void refreshSocket() {
        if (this.socket.isClosed()) {
            this.context.info(this.socketName + " --- Socket closed, reopening it, listening for queries");
            try {
                this.socket = MulticastUtil.newMulticastSocket(this.bindAddress, this.context);
                this.socketName = MulticastUtil.getReadableSocketName(this.socket);
            }
            catch (IOException exp) {
                int multicastPort = Integer.parseInt(this.context.getConfig(ConfigKey.MULTICAST_PORT));
                String name = MulticastUtil.getReadableSocketName(this.bindAddress, multicastPort);
                this.context.error(name + " --- Can not reopen socket. Exiting multicast listener thread...", exp);
                throw new SocketVerificationFailedException(exp);
            }
        }
    }

    private void handleQuery(DiscoveryIncomingMessage pMsg) {
        DiscoveryOutgoingMessage answer = new DiscoveryOutgoingMessage.Builder(AbstractDiscoveryMessage.MessageType.RESPONSE).respondTo(pMsg).agentDetails(this.context.getAgentDetails()).build();
        this.context.debug(this.socketName + " <-- " + MulticastUtil.getReadableSocketName(pMsg.getSourceAddress(), pMsg.getSourcePort()) + " - Received discovery request from external client");
        this.send(answer);
    }

    private void send(DiscoveryOutgoingMessage pAnswer) {
        byte[] message = pAnswer.getData();
        DatagramPacket packet = new DatagramPacket(message, message.length, pAnswer.getTargetAddress(), pAnswer.getTargetPort());
        if (!this.socket.isClosed()) {
            try {
                this.socket.send(packet);
            }
            catch (IOException exp) {
                this.context.info(this.socketName + " --> " + MulticastUtil.getReadableSocketName(packet.getAddress(), packet.getPort()) + " - Can not send discovery response: " + exp.getMessage());
            }
        }
    }

    private static class SocketVerificationFailedException
    extends RuntimeException {
        public SocketVerificationFailedException(IOException e) {
            super(e);
        }
    }
}

