/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.detector.jee;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jolokia.server.core.detector.DefaultServerHandle;
import org.jolokia.server.core.service.api.ServerHandle;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.server.detector.jee.AbstractServerDetector;

public class TomcatDetector
extends AbstractServerDetector {
    private static final Pattern SERVER_INFO_PATTERN = Pattern.compile("^\\s*([^/]+)\\s*/\\s*([\\d.]+(-RC\\d+)?).*", 2);

    public TomcatDetector(int pOrder) {
        super("tomcat", pOrder);
    }

    @Override
    public ServerHandle detect(MBeanServerAccess pMBeanServerAccess) {
        String serverInfo = this.getSingleStringAttribute(pMBeanServerAccess, "*:type=Server", "serverInfo");
        if (serverInfo == null) {
            return null;
        }
        Matcher matcher = SERVER_INFO_PATTERN.matcher(serverInfo);
        if (matcher.matches()) {
            String product = matcher.group(1);
            String version = matcher.group(2);
            if (product.toLowerCase().contains("tomcat")) {
                return new DefaultServerHandle("Apache", this.getName(), version);
            }
        }
        return null;
    }
}

