/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.service.api.AgentDetails;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.api.LogHandler;
import org.jolokia.server.core.service.impl.QuietLogHandler;
import org.jolokia.server.core.util.NetworkInterfaceAndAddress;
import org.jolokia.server.core.util.NetworkUtil;
import org.jolokia.service.discovery.DiscoveryIncomingMessage;
import org.jolokia.service.discovery.DiscoveryOutgoingMessage;

public final class MulticastUtil {
    private MulticastUtil() {
    }

    static MulticastSocket newMulticastSocket(InetAddress pAddress, JolokiaContext pContext) throws IOException {
        String multicastGroup = pContext.getConfig(ConfigKey.MULTICAST_GROUP);
        int multicastPort = Integer.parseInt(pContext.getConfig(ConfigKey.MULTICAST_PORT));
        InetSocketAddress mcSocketAddress = new InetSocketAddress(multicastGroup, multicastPort);
        MulticastSocket socket = pAddress == null ? new MulticastSocket(multicastPort) : new MulticastSocket(new InetSocketAddress(pAddress, multicastPort));
        socket.setTimeToLive(255);
        if (MulticastUtil.joinMcGroupsOnAllNetworkInterfaces(socket, mcSocketAddress, pContext) == 0) {
            throw new IOException("Couldn't join multicast group " + String.valueOf(mcSocketAddress) + " on any network interfaces");
        }
        return socket;
    }

    public static List<DiscoveryIncomingMessage> sendQueryAndCollectAnswers(DiscoveryOutgoingMessage pOutMsg, int pTimeout, String pMulticastGroup, int pMulticastPort) throws IOException {
        return MulticastUtil.sendQueryAndCollectAnswers(pOutMsg, pTimeout, pMulticastGroup, pMulticastPort, new QuietLogHandler());
    }

    public static List<DiscoveryIncomingMessage> sendQueryAndCollectAnswers(DiscoveryOutgoingMessage pOutMsg, int pTimeout, String pMulticastGroup, int pMulticastPort, LogHandler pLogHandler) throws IOException {
        List<Future<List<DiscoveryIncomingMessage>>> futures = MulticastUtil.sendDiscoveryRequests(pOutMsg, pTimeout, pMulticastGroup, pMulticastPort, pLogHandler);
        return MulticastUtil.collectIncomingMessages(pTimeout, futures, pLogHandler);
    }

    public static String getReadableSocketName(MulticastSocket socket) {
        if (socket == null || socket.isClosed()) {
            return "???:-1";
        }
        InetAddress localAddress = socket.getLocalAddress();
        int localPort = socket.getLocalPort();
        return MulticastUtil.getReadableSocketName(localAddress, localPort);
    }

    public static String getReadableSocketName(InetAddress address, int port) {
        if (address instanceof Inet6Address) {
            return String.format("[%s]:%d", address.getHostAddress(), port);
        }
        return address.getHostAddress() + ":" + port;
    }

    private static List<Future<List<DiscoveryIncomingMessage>>> sendDiscoveryRequests(DiscoveryOutgoingMessage pOutMsg, int pTimeout, String pMulticastGroup, int pMulticastPort, LogHandler pLogHandler) throws UnknownHostException {
        List<NetworkInterfaceAndAddress> addresses = MulticastUtil.getMulticastAddresses();
        ExecutorService executor = Executors.newFixedThreadPool(addresses.size());
        ArrayList<Future<List<DiscoveryIncomingMessage>>> futures = new ArrayList<Future<List<DiscoveryIncomingMessage>>>(addresses.size());
        DatagramPacket out = pOutMsg.createDatagramPacket(InetAddress.getByName(pMulticastGroup), pMulticastPort);
        boolean targetIsIPv4 = out.getAddress() instanceof Inet4Address;
        for (NetworkInterfaceAndAddress pair : addresses) {
            InetAddress address = pair.address;
            if (address.isLinkLocalAddress()) {
                pLogHandler.debug(MulticastUtil.getReadableSocketName(address, 0) + " --> " + MulticastUtil.getReadableSocketName(out.getAddress(), out.getPort()) + " - Skipping link local address");
                continue;
            }
            if (address instanceof Inet6Address && targetIsIPv4 || address instanceof Inet4Address && !targetIsIPv4) continue;
            FindAgentsCallable findAgentsCallable = new FindAgentsCallable(pair, out, pTimeout, pLogHandler);
            futures.add(executor.submit(findAgentsCallable));
        }
        executor.shutdownNow();
        return futures;
    }

    private static List<NetworkInterfaceAndAddress> getMulticastAddresses() throws UnknownHostException {
        List<NetworkInterfaceAndAddress> addresses = NetworkUtil.getMulticastAddresses();
        if (addresses.isEmpty()) {
            throw new UnknownHostException("Cannot find address of local host which can be used for sending discovery request");
        }
        return addresses;
    }

    private static List<DiscoveryIncomingMessage> collectIncomingMessages(int pTimeout, List<Future<List<DiscoveryIncomingMessage>>> pFutures, LogHandler pLogHandler) throws UnknownHostException {
        ArrayList<DiscoveryIncomingMessage> ret = new ArrayList<DiscoveryIncomingMessage>();
        HashSet<String> seen = new HashSet<String>();
        int nrCouldntSend = 0;
        for (Future<List<DiscoveryIncomingMessage>> future : pFutures) {
            try {
                List<DiscoveryIncomingMessage> inMsgs = future.get(pTimeout + 500, TimeUnit.MILLISECONDS);
                for (DiscoveryIncomingMessage inMsg : inMsgs) {
                    AgentDetails details = inMsg.getAgentDetails();
                    String id = details.getAgentId();
                    if (seen.contains(id)) continue;
                    ret.add(inMsg);
                    seen.add(id);
                }
            }
            catch (InterruptedException inMsgs) {
            }
            catch (ExecutionException e) {
                Throwable exp = e.getCause();
                if (exp instanceof CouldntSendDiscoveryPacketException) {
                    ++nrCouldntSend;
                    String source = MulticastUtil.getReadableSocketName(((CouldntSendDiscoveryPacketException)exp).getAddress(), ((CouldntSendDiscoveryPacketException)exp).getPort());
                    String target = ((CouldntSendDiscoveryPacketException)exp).getTarget();
                    pLogHandler.debug(source + " --> " + target + " - Couldn't send discovery request: " + exp.getMessage());
                    continue;
                }
                pLogHandler.debug("Exception during lookup: " + String.valueOf(e));
            }
            catch (TimeoutException timeoutException) {
            }
        }
        if (nrCouldntSend == pFutures.size()) {
            throw new UnknownHostException("Cannot send a single multicast recovery request on any multicast enabled interface");
        }
        return ret;
    }

    private static int joinMcGroupsOnAllNetworkInterfaces(MulticastSocket pSocket, InetSocketAddress pMCAddress, LogHandler pLogHandler) throws IOException {
        Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
        int interfacesJoined = 0;
        while (nifs.hasMoreElements()) {
            NetworkInterface n = nifs.nextElement();
            if (!NetworkUtil.isMulticastSupported(n)) continue;
            try {
                pLogHandler.debug(MulticastUtil.getReadableSocketName(pSocket) + " +-- Joining MC group " + MulticastUtil.getReadableSocketName(pMCAddress.getAddress(), pMCAddress.getPort()) + " on interface " + n.getName());
                pSocket.joinGroup(pMCAddress, n);
                ++interfacesJoined;
            }
            catch (IOException exp) {
                pLogHandler.info("Cannot join multicast group on NIF " + n.getDisplayName() + ": " + exp.getMessage());
            }
        }
        return interfacesJoined;
    }

    private static final class FindAgentsCallable
    implements Callable<List<DiscoveryIncomingMessage>> {
        private final NetworkInterfaceAndAddress pair;
        private final DatagramPacket outPacket;
        private final int timeout;
        private final LogHandler logHandler;

        private FindAgentsCallable(NetworkInterfaceAndAddress pAddress, DatagramPacket pOutPacket, int pTimeout, LogHandler pLogHandler) {
            this.pair = pAddress;
            this.outPacket = pOutPacket;
            this.timeout = pTimeout;
            this.logHandler = pLogHandler;
        }

        @Override
        public List<DiscoveryIncomingMessage> call() throws IOException {
            DatagramSocket socket = new DatagramSocket(0, this.pair.address);
            String source = MulticastUtil.getReadableSocketName(socket.getLocalAddress(), socket.getLocalPort());
            String target = MulticastUtil.getReadableSocketName(this.outPacket.getAddress(), this.outPacket.getPort());
            try (DatagramSocket datagramSocket = socket;){
                ArrayList<DiscoveryIncomingMessage> ret = new ArrayList<DiscoveryIncomingMessage>();
                try {
                    socket.setSoTimeout(this.timeout);
                    this.logHandler.debug(source + " --> " + target + " - Sending discovery request via " + this.pair.networkInterface.getName());
                    socket.send(this.outPacket);
                }
                catch (IOException exp) {
                    throw new CouldntSendDiscoveryPacketException(this.pair, socket.getLocalPort(), target, exp.getMessage(), exp);
                }
                try {
                    while (true) {
                        byte[] buf = new byte[8972];
                        DatagramPacket in = new DatagramPacket(buf, buf.length);
                        socket.receive(in);
                        this.logHandler.debug(source + " <-- " + MulticastUtil.getReadableSocketName(in.getAddress(), in.getPort()) + " - Received discovery response");
                        this.addIncomingMessage(ret, in);
                    }
                }
                catch (SocketTimeoutException exp) {
                    this.logHandler.debug(source + " <-- " + target + " - Timeout (no more messages)");
                }
                catch (IOException exp) {
                    throw new IOException("Cannot receive broadcast answer on " + String.valueOf(this.pair) + ": " + exp.getMessage(), exp);
                }
                ArrayList<DiscoveryIncomingMessage> arrayList = ret;
                return arrayList;
            }
        }

        private void addIncomingMessage(List<DiscoveryIncomingMessage> ret, DatagramPacket in) {
            try {
                DiscoveryIncomingMessage inMsg = new DiscoveryIncomingMessage(in);
                if (!inMsg.isQuery()) {
                    ret.add(inMsg);
                }
            }
            catch (Exception exp) {
                this.logHandler.debug("Invalid incoming package from " + String.valueOf(in.getAddress()) + "  --> " + String.valueOf(exp) + ". Ignoring");
            }
        }
    }

    private static class CouldntSendDiscoveryPacketException
    extends IOException {
        private final NetworkInterfaceAndAddress pair;
        private final int localPort;
        private final String target;

        public CouldntSendDiscoveryPacketException(NetworkInterfaceAndAddress pair, int localPort, String target, String pMessage, IOException pNested) {
            super(pMessage, pNested);
            this.pair = pair;
            this.localPort = localPort;
            this.target = target;
        }

        public InetAddress getAddress() {
            return this.pair.address;
        }

        public int getPort() {
            return this.localPort;
        }

        public NetworkInterface getNetworkInterface() {
            return this.pair.networkInterface;
        }

        public String getTarget() {
            return this.target;
        }
    }
}

