/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.agent.osgi;

import java.util.Arrays;
import java.util.List;
import org.jolokia.server.core.osgi.OsgiAgentActivator;
import org.jolokia.server.detector.osgi.DetectorActivator;
import org.jolokia.service.discovery.osgi.DiscoveryServiceActivator;
import org.jolokia.service.history.osgi.HistoryServiceActivator;
import org.jolokia.service.jmx.osgi.JmxServiceActivator;
import org.jolokia.service.notif.pull.osgi.PullNotificationServiceActivator;
import org.jolokia.service.notif.sse.osgi.SseNotificationServiceActivator;
import org.jolokia.service.serializer.osgi.SerializerServiceActivator;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class JolokiaBundleActivator
implements BundleActivator {
    List<BundleActivator> activators = Arrays.asList(new OsgiAgentActivator(), new DetectorActivator(), new JmxServiceActivator(), new SerializerServiceActivator(), new DiscoveryServiceActivator(), new HistoryServiceActivator(), new PullNotificationServiceActivator(), new SseNotificationServiceActivator());

    public void start(BundleContext pContext) {
        for (BundleActivator activator : this.activators) {
            try {
                activator.start(pContext);
            }
            catch (Exception exp) {
                this.logError(pContext, "Error during start with " + String.valueOf(activator) + ": " + String.valueOf(exp), exp);
            }
        }
    }

    public void stop(BundleContext pContext) {
        for (BundleActivator activator : this.activators) {
            try {
                activator.stop(pContext);
            }
            catch (Exception exp) {
                this.logError(pContext, "Error during stop for " + String.valueOf(activator) + ": " + String.valueOf(exp), exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logError(BundleContext ctx, String pTxt, Exception pExp) {
        ServiceReference ref = ctx.getServiceReference(LogService.class.getName());
        if (ref != null) {
            try {
                LogService service = (LogService)ctx.getService(ref);
                if (service != null) {
                    service.log(1, pTxt, (Throwable)pExp);
                    return;
                }
            }
            finally {
                ctx.ungetService(ref);
            }
        }
        System.err.println("E> " + pTxt);
        pExp.printStackTrace();
    }
}

