/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.detector.osgi;

import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jolokia.server.core.detector.ServerDetector;
import org.jolokia.server.core.detector.ServerDetectorLookup;
import org.jolokia.server.core.util.LocalServiceFactory;
import org.jolokia.server.detector.osgi.EquinoxDetector;
import org.jolokia.server.detector.osgi.FelixDetector;
import org.jolokia.server.detector.osgi.KnopflerfishDetector;
import org.jolokia.server.detector.osgi.VirgoDetector;
import org.osgi.framework.BundleContext;

public class OsgiServerDetectorLookup
implements ServerDetectorLookup {
    private final BundleContext context;

    OsgiServerDetectorLookup(BundleContext pContext) {
        this.context = pContext;
    }

    @Override
    public SortedSet<ServerDetector> lookup() {
        TreeSet<ServerDetector> detectors = new TreeSet<ServerDetector>();
        detectors.addAll(this.classpathDetectors());
        detectors.addAll(this.osgiDetectors());
        detectors.add(ServerDetector.FALLBACK);
        return detectors;
    }

    private List<ServerDetector> osgiDetectors() {
        return Arrays.asList(new VirgoDetector(this.context), new FelixDetector(this.context), new EquinoxDetector(this.context), new KnopflerfishDetector(this.context));
    }

    private List<ServerDetector> classpathDetectors() {
        return LocalServiceFactory.createServices(this.getClass().getClassLoader(), "META-INF/jolokia/detectors-default", "META-INF/jolokia/detectors");
    }
}

