/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.restrictor.policy;

import java.io.IOException;
import java.io.InputStream;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jolokia.server.core.restrictor.policy.CorsChecker;
import org.jolokia.server.core.restrictor.policy.HttpMethodChecker;
import org.jolokia.server.core.restrictor.policy.MBeanAccessChecker;
import org.jolokia.server.core.restrictor.policy.NetworkChecker;
import org.jolokia.server.core.restrictor.policy.RequestTypeChecker;
import org.jolokia.server.core.service.api.Restrictor;
import org.jolokia.server.core.util.HttpMethod;
import org.jolokia.server.core.util.RequestType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PolicyRestrictor
implements Restrictor {
    private HttpMethodChecker httpChecker;
    private RequestTypeChecker requestTypeChecker;
    private NetworkChecker networkChecker;
    private CorsChecker corsChecker;
    private MBeanAccessChecker mbeanAccessChecker;

    public PolicyRestrictor(InputStream pInput) {
        Exception exp = null;
        if (pInput == null) {
            throw new SecurityException("No policy file given");
        }
        try {
            Document doc = this.createDocument(pInput);
            this.requestTypeChecker = new RequestTypeChecker(doc);
            this.httpChecker = new HttpMethodChecker(doc);
            this.networkChecker = new NetworkChecker(doc);
            this.mbeanAccessChecker = new MBeanAccessChecker(doc);
            this.corsChecker = new CorsChecker(doc);
        }
        catch (IOException | MalformedObjectNameException | ParserConfigurationException | SAXException e) {
            exp = e;
        }
        if (exp != null) {
            throw new SecurityException("Cannot parse policy file: " + exp, exp);
        }
    }

    private Document createDocument(InputStream pInput) throws ParserConfigurationException, SAXException, IOException {
        String[] features;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        for (String feature : features = new String[]{"http://xml.org/sax/features/external-general-entities", "http://xml.org/sax/features/external-parameter-entities", "http://apache.org/xml/features/nonvalidating/load-external-dtd"}) {
            try {
                factory.setFeature(feature, false);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return factory.newDocumentBuilder().parse(pInput);
    }

    @Override
    public boolean isHttpMethodAllowed(HttpMethod method) {
        return this.httpChecker.check(method);
    }

    @Override
    public boolean isTypeAllowed(RequestType pType) {
        return this.requestTypeChecker.check(pType);
    }

    @Override
    public boolean isRemoteAccessAllowed(String ... pHostOrAddress) {
        return this.networkChecker.check(pHostOrAddress);
    }

    @Override
    public boolean isOriginAllowed(String pOrigin, boolean pOnlyWhenStrictCheckingIsEnabled) {
        return this.corsChecker.check(pOrigin, pOnlyWhenStrictCheckingIsEnabled);
    }

    @Override
    public boolean isAttributeReadAllowed(ObjectName pName, String pAttribute) {
        return this.check(RequestType.READ, pName, pAttribute);
    }

    @Override
    public boolean isAttributeWriteAllowed(ObjectName pName, String pAttribute) {
        return this.check(RequestType.WRITE, pName, pAttribute);
    }

    @Override
    public boolean isOperationAllowed(ObjectName pName, String pOperation) {
        return this.check(RequestType.EXEC, pName, pOperation);
    }

    private boolean check(RequestType pType, ObjectName pName, String pValue) {
        return this.mbeanAccessChecker.check(new MBeanAccessChecker.Arg(this.isTypeAllowed(pType), pType, pName, pValue));
    }
}

