/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.request;

import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.request.ProcessingParameters;
import org.jolokia.server.core.util.ProviderUtil;
import org.jolokia.server.core.util.RequestType;
import org.json.simple.JSONObject;

public abstract class JolokiaObjectNameRequest
extends JolokiaRequest {
    private ObjectName objectName;
    private String provider;

    protected JolokiaObjectNameRequest(RequestType pType, String pName, List<String> pPathParts, ProcessingParameters pProcessingParams, boolean pExclusive) throws MalformedObjectNameException {
        super(pType, pPathParts, pProcessingParams, pExclusive);
        this.initObjectName(pName);
    }

    protected JolokiaObjectNameRequest(Map<String, ?> pRequestMap, ProcessingParameters pParams, boolean pExclusive) throws MalformedObjectNameException {
        super(pRequestMap, pParams, pExclusive);
        this.initObjectName((String)pRequestMap.get("mbean"));
    }

    @Override
    public JSONObject toJSON() {
        JSONObject ret = super.toJSON();
        ret.put("mbean", this.getOrderedObjectName(this.objectName));
        if (this.provider != null) {
            ret.put("provider", this.provider);
        }
        return ret;
    }

    @Override
    protected String getInfo() {
        String baseInfo;
        StringBuilder ret = new StringBuilder("objectName = ").append(this.objectName.getCanonicalName());
        if (this.provider != null) {
            ret.append(", provider = ").append(this.provider);
        }
        if ((baseInfo = super.getInfo()) != null) {
            ret.append(", ").append(baseInfo);
        }
        return ret.toString();
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getObjectNameAsString() {
        return this.objectName.getCanonicalName();
    }

    public String getOrderedObjectName(ObjectName pName) {
        if (pName.isPattern()) {
            return pName.getCanonicalName();
        }
        if (this.getParameterAsBool(ConfigKey.CANONICAL_NAMING).booleanValue()) {
            return pName.getCanonicalName();
        }
        return pName.getDomain() + ":" + pName.getKeyPropertyListString();
    }

    private void initObjectName(String pObjectName) throws MalformedObjectNameException {
        ProviderUtil.ProviderObjectNamePair pair = ProviderUtil.extractProvider(pObjectName);
        this.provider = pair.getProvider();
        this.objectName = pair.getObjectName();
    }
}

