/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler.notification;

import java.io.IOException;
import javax.management.JMException;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.request.BadRequestException;
import org.jolokia.server.core.request.EmptyResponseException;
import org.jolokia.server.core.request.notification.AddCommand;
import org.jolokia.server.core.request.notification.ClientCommand;
import org.jolokia.server.core.request.notification.NotificationCommand;
import org.jolokia.server.core.request.notification.OpenCommand;
import org.jolokia.server.core.request.notification.RemoveCommand;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.notification.NotificationBackendManager;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.service.jmx.handler.notification.NotificationListenerDelegate;

public class NotificationDispatcher {
    private final NotificationListenerDelegate listenerDelegate;
    private final NotificationBackendManager backendManager;

    public NotificationDispatcher(JolokiaContext pContext) {
        this.backendManager = new NotificationBackendManager(pContext);
        this.listenerDelegate = new NotificationListenerDelegate(this.backendManager);
    }

    public Object dispatch(MBeanServerAccess pExecutor, NotificationCommand pCommand) throws IOException, JMException, BadRequestException, EmptyResponseException {
        String client = pCommand instanceof ClientCommand ? ((ClientCommand)pCommand).getClient() : null;
        switch (pCommand.getType()) {
            case REGISTER: {
                return this.register();
            }
            case UNREGISTER: {
                this.listenerDelegate.unregister(pExecutor, client);
                return null;
            }
            case ADD: {
                if (pCommand instanceof AddCommand) {
                    AddCommand addCommand = (AddCommand)pCommand;
                    return this.listenerDelegate.addListener(pExecutor, addCommand);
                }
                throw new IllegalArgumentException("Expected Notification ADD command, got " + String.valueOf((Object)pCommand.getType()));
            }
            case REMOVE: {
                if (pCommand instanceof RemoveCommand) {
                    RemoveCommand removeCommand = (RemoveCommand)pCommand;
                    this.listenerDelegate.removeListener(pExecutor, client, removeCommand.getHandle());
                    return null;
                }
                throw new IllegalArgumentException("Expected Notification REMOVE command, got " + String.valueOf((Object)pCommand.getType()));
            }
            case PING: {
                this.listenerDelegate.refresh(client);
                return null;
            }
            case OPEN: {
                if (pCommand instanceof OpenCommand) {
                    OpenCommand openCommand = (OpenCommand)pCommand;
                    this.listenerDelegate.openChannel(openCommand);
                    throw new EmptyResponseException();
                }
                throw new IllegalArgumentException("Expected Notification OPEN command, got " + String.valueOf((Object)pCommand.getType()));
            }
            case LIST: {
                return this.listenerDelegate.list(client);
            }
        }
        throw new BadRequestException("Unsupported notification command " + String.valueOf((Object)pCommand.getType()));
    }

    private JSONObject register() {
        String id = this.listenerDelegate.register();
        JSONObject ret = new JSONObject();
        ret.put("id", id);
        ret.put("backend", this.backendManager.getBackendConfig());
        return ret;
    }
}

