/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler.list;

import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenType;
import org.jolokia.converter.object.OpenTypeHelper;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.service.api.DataUpdater;
import org.jolokia.server.core.service.api.OpenTypeAwareDataUpdate;
import org.jolokia.server.core.util.JsonUtil;
import org.jolokia.service.jmx.handler.list.DataKeys;

class OperationDataUpdater
extends DataUpdater
implements OpenTypeAwareDataUpdate {
    protected OperationDataUpdater() {
        super(100);
    }

    @Override
    public String getKey() {
        return DataKeys.OPERATIONS.getKey();
    }

    @Override
    public JSONObject extractData(ObjectName pObjectName, MBeanInfo pMBeanInfo, String pOperation) {
        JSONObject opMap = new JSONObject();
        for (MBeanOperationInfo opInfo : pMBeanInfo.getOperations()) {
            if (pOperation != null && !opInfo.getName().equals(pOperation)) continue;
            JSONObject map = new JSONObject();
            JSONArray argList = new JSONArray(opInfo.getSignature().length);
            for (MBeanParameterInfo paramInfo : opInfo.getSignature()) {
                JSONObject args = OperationDataUpdater.parameterData(paramInfo);
                argList.add(args);
            }
            map.put(DataKeys.ARGS.getKey(), argList);
            map.put(DataKeys.RETURN_TYPE.getKey(), opInfo.getReturnType());
            map.put(DataKeys.DESCRIPTION.getKey(), opInfo.getDescription());
            JsonUtil.addJSONObjectToJSONObject(opMap, opInfo.getName(), map);
        }
        return opMap;
    }

    @Override
    public JSONObject extractDataWithOpenTypes(ObjectName pObjectName, MBeanInfo pMBeanInfo, String pOperation) {
        JSONObject opMap = new JSONObject();
        for (MBeanOperationInfo opInfo : pMBeanInfo.getOperations()) {
            if (pOperation != null && !opInfo.getName().equals(pOperation)) continue;
            JSONObject map = new JSONObject();
            JSONArray argList = new JSONArray(opInfo.getSignature().length);
            for (MBeanParameterInfo paramInfo : opInfo.getSignature()) {
                JSONObject args = OperationDataUpdater.parameterData(paramInfo);
                if (paramInfo instanceof OpenMBeanParameterInfo) {
                    OpenMBeanParameterInfo openMBeanParameterInfo = (OpenMBeanParameterInfo)((Object)paramInfo);
                    args.put(DataKeys.OPEN_TYPE.getKey(), OpenTypeHelper.toJSON(openMBeanParameterInfo.getOpenType(), (MBeanFeatureInfo)paramInfo));
                } else {
                    OpenType<?> openType = OpenTypeHelper.findOpenType(paramInfo.getDescriptor());
                    if (openType != null) {
                        args.put(DataKeys.OPEN_TYPE.getKey(), OpenTypeHelper.toJSON(openType, (MBeanFeatureInfo)paramInfo));
                    }
                }
                argList.add(args);
            }
            map.put(DataKeys.ARGS.getKey(), argList);
            map.put(DataKeys.RETURN_TYPE.getKey(), opInfo.getReturnType());
            map.put(DataKeys.DESCRIPTION.getKey(), opInfo.getDescription());
            if (opInfo instanceof OpenMBeanOperationInfo) {
                OpenMBeanOperationInfo openMBeanOperationInfo = (OpenMBeanOperationInfo)((Object)opInfo);
                map.put(DataKeys.RETURN_OPEN_TYPE.getKey(), OpenTypeHelper.toJSON(openMBeanOperationInfo.getReturnOpenType(), (MBeanFeatureInfo)opInfo));
            } else {
                OpenType<?> openType = OpenTypeHelper.findOpenType(opInfo.getDescriptor());
                if (openType != null) {
                    map.put(DataKeys.RETURN_OPEN_TYPE.getKey(), OpenTypeHelper.toJSON(openType, (MBeanFeatureInfo)opInfo));
                }
            }
            JsonUtil.addJSONObjectToJSONObject(opMap, opInfo.getName(), map);
        }
        return opMap;
    }

    private static JSONObject parameterData(MBeanParameterInfo paramInfo) {
        JSONObject args = new JSONObject();
        args.put(DataKeys.DESCRIPTION.getKey(), paramInfo.getDescription());
        args.put(DataKeys.NAME.getKey(), paramInfo.getName());
        args.put(DataKeys.TYPE.getKey(), paramInfo.getType());
        return args;
    }
}

