/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler.list;

import java.io.IOException;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.core.util.ErrorUtil;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.request.BadRequestException;
import org.jolokia.server.core.request.JolokiaListRequest;
import org.jolokia.server.core.service.api.DataUpdater;
import org.jolokia.server.core.service.api.OpenTypeAwareDataUpdate;
import org.jolokia.service.jmx.api.CacheKeyProvider;
import org.jolokia.service.jmx.handler.list.AttributeDataUpdater;
import org.jolokia.service.jmx.handler.list.ClassNameDataUpdater;
import org.jolokia.service.jmx.handler.list.ConstructorDataUpdater;
import org.jolokia.service.jmx.handler.list.DescriptionDataUpdater;
import org.jolokia.service.jmx.handler.list.ListInterfacesDataUpdater;
import org.jolokia.service.jmx.handler.list.ListKeysDataUpdater;
import org.jolokia.service.jmx.handler.list.NotificationDataUpdater;
import org.jolokia.service.jmx.handler.list.OperationDataUpdater;

public class MBeanInfoData {
    private int maxDepth;
    private final ObjectName pathObjectName;
    private final String selectedUpdater;
    private int retrieveAtDepth = 0;
    private final JSONObject infoMap = new JSONObject();
    private static final Map<String, DataUpdater> UPDATERS = new HashMap<String, DataUpdater>();
    private static final DataUpdater LIST_KEYS_UPDATER = new ListKeysDataUpdater();
    private static final ListInterfacesDataUpdater LIST_INTERFACES_UPDATER = new ListInterfacesDataUpdater();
    private final boolean useCanonicalName;
    private final boolean listKeys;
    private final boolean listInterfaces;
    private final boolean listOpenTypes;
    private boolean listCache;
    private final Map<ObjectName, JSONObject> cache;
    private final Map<ObjectName, JSONObject> noOpenTypeCache;
    private final String pProvider;

    public MBeanInfoData(Deque<String> pPathStack, String pProvider, JolokiaListRequest pRequest, Map<ObjectName, JSONObject> pMBeanInfoCache, Map<ObjectName, JSONObject> pNoOpenTypeCache) throws BadRequestException {
        this.maxDepth = pRequest.getParameterAsInt(ConfigKey.MAX_DEPTH);
        this.useCanonicalName = pRequest.getParameterAsBool(ConfigKey.CANONICAL_NAMING);
        this.listKeys = pRequest.getParameterAsBool(ConfigKey.LIST_KEYS);
        this.listCache = pRequest.getParameterAsBool(ConfigKey.LIST_CACHE);
        this.listInterfaces = pRequest.getParameterAsBool(ConfigKey.LIST_INTERFACES);
        this.listOpenTypes = pRequest.getParameterAsBool(ConfigKey.OPEN_TYPES);
        if (this.listOpenTypes) {
            this.maxDepth = 0;
        }
        this.cache = pMBeanInfoCache;
        this.noOpenTypeCache = pNoOpenTypeCache;
        LinkedList<String> pathStack = pPathStack != null ? new LinkedList<String>(pPathStack) : new LinkedList();
        this.pProvider = pProvider;
        try {
            if (pathStack.isEmpty()) {
                this.pathObjectName = null;
            } else {
                String domain = (String)pathStack.pop();
                if (domain == null) {
                    domain = "*";
                }
                domain = this.removeProviderIfNeeded(domain);
                String name = "*";
                if (!pathStack.isEmpty() && (name = (String)pathStack.pop()) == null) {
                    name = "*";
                }
                ObjectName objectName = this.pathObjectName = "*".equals(domain) && "*".equals(name) ? null : new ObjectName(domain + ":" + name);
                if (this.pathObjectName != null && !this.pathObjectName.isDomainPattern()) {
                    ++this.retrieveAtDepth;
                    if (!this.pathObjectName.isPropertyListPattern() && !this.pathObjectName.isPropertyValuePattern()) {
                        ++this.retrieveAtDepth;
                    }
                }
            }
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (this.pathObjectName != null && !this.pathObjectName.isPattern()) {
            this.listCache = false;
        }
        if (pathStack.isEmpty()) {
            this.selectedUpdater = null;
        } else {
            this.selectedUpdater = (String)pathStack.pop();
            if (this.pathObjectName != null && !this.pathObjectName.isPattern()) {
                ++this.retrieveAtDepth;
            }
        }
        if (!pathStack.isEmpty()) {
            throw new BadRequestException("List operation supports only 3 path segments for MBean domain,canonical list of ObjectName properties and updater to use. Remaining path: " + String.join((CharSequence)", ", pathStack));
        }
    }

    public boolean handleFirstOrSecondLevel(ObjectName pName) {
        if (this.maxDepth > 2 || this.maxDepth == 0) {
            return false;
        }
        if (this.maxDepth == 1) {
            if (this.pathObjectName == null || this.pathObjectName.apply(pName)) {
                this.infoMap.put(this.addProviderIfNeeded(pName.getDomain()), 1);
            }
            return true;
        }
        if (this.maxDepth == 2) {
            if (this.pathObjectName == null || this.pathObjectName.apply(pName)) {
                JSONObject domain = this.getOrCreateJSONObject(this.infoMap, this.addProviderIfNeeded(pName.getDomain()));
                domain.put(this.getKeyPropertyString(pName), 1);
            }
            return true;
        }
        return false;
    }

    private String getKeyPropertyString(ObjectName pName) {
        return this.useCanonicalName ? pName.getCanonicalKeyPropertyListString() : pName.getKeyPropertyListString();
    }

    public void addMBeanInfo(MBeanServerConnection pConn, ObjectInstance pInstance, Set<DataUpdater> customUpdaters, Set<CacheKeyProvider> cacheKeyProviders) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        JSONObject domain;
        if (this.pathObjectName != null && !this.pathObjectName.apply(pInstance.getObjectName())) {
            return;
        }
        ObjectName objectName = pInstance.getObjectName();
        MBeanInfo mBeanInfo = pConn.getMBeanInfo(objectName);
        String domainName = this.addProviderIfNeeded(objectName.getDomain());
        String mbeanKeyListing = this.getKeyPropertyString(objectName);
        JSONObject mbean = null;
        if (this.listCache) {
            JSONObject domains = this.getOrCreateJSONObject(this.infoMap, "domains");
            domain = this.getOrCreateJSONObject(domains, domainName);
        } else {
            domain = this.getOrCreateJSONObject(this.infoMap, domainName);
            mbean = this.getOrCreateJSONObject(domain, mbeanKeyListing);
        }
        if (!this.listCache) {
            this.addFullMBeanInfo(pConn, mbean, objectName, mBeanInfo, objectName, customUpdaters);
        } else {
            CacheKeyProvider provider;
            String key = null;
            Iterator<CacheKeyProvider> iterator = cacheKeyProviders.iterator();
            while (iterator.hasNext() && (key = (provider = iterator.next()).determineKey(pInstance)) == null) {
            }
            JSONObject cache = this.getOrCreateJSONObject(this.infoMap, "cache");
            if (key != null) {
                domain.put(mbeanKeyListing, key);
                mbean = this.getOrCreateJSONObject(cache, key);
                if (mbean.isEmpty()) {
                    this.addFullMBeanInfo(pConn, mbean, objectName, mBeanInfo, objectName, customUpdaters);
                }
            } else {
                mbean = this.getOrCreateJSONObject(domain, mbeanKeyListing);
                this.addFullMBeanInfo(pConn, mbean, objectName, mBeanInfo, objectName, customUpdaters);
            }
        }
        if (mbean != null && mbean.isEmpty()) {
            domain.remove(mbeanKeyListing);
            if (domain.isEmpty()) {
                this.infoMap.remove(domainName);
            }
        }
    }

    private String addProviderIfNeeded(String pDomain) {
        return this.pProvider != null ? this.pProvider + "@" + pDomain : pDomain;
    }

    private String removeProviderIfNeeded(String pDomain) {
        return this.pProvider != null && pDomain.startsWith(this.pProvider) ? pDomain.substring(this.pProvider.length() + 1) : pDomain;
    }

    public void handleException(ObjectName pName, IOException pExp) throws IOException {
        if (this.retrieveAtDepth != 0) {
            throw new IOException("IOException for MBean " + String.valueOf(pName) + " (" + pExp.getMessage() + ")", pExp);
        }
        this.addException(pName, pExp);
    }

    public void handleException(ObjectName pName, IllegalStateException pExp) {
        if (this.retrieveAtDepth != 0) {
            throw new IllegalStateException("IllegalStateException for MBean " + String.valueOf(pName) + " (" + pExp.getMessage() + ")", pExp);
        }
        this.addException(pName, pExp);
    }

    public void handleException(ObjectName pName, InstanceNotFoundException pExp) throws InstanceNotFoundException {
        if (this.retrieveAtDepth != 0) {
            throw new InstanceNotFoundException("InstanceNotFoundException for MBean " + String.valueOf(pName) + " (" + pExp.getMessage() + ")");
        }
        this.addException(pName, pExp);
    }

    private void addException(ObjectName pName, Exception pExp) {
        JSONObject domain = this.getOrCreateJSONObject(this.infoMap, this.addProviderIfNeeded(pName.getDomain()));
        JSONObject mbean = this.getOrCreateJSONObject(domain, this.getKeyPropertyString(pName));
        ErrorUtil.addBasicErrorResponseInformation(mbean, pExp);
    }

    public Object applyPath() {
        Object value = this.navigatePath();
        if (this.maxDepth == 0) {
            return value;
        }
        if (!(value instanceof JSONObject)) {
            return value;
        }
        return this.truncateJSONObject((JSONObject)value, this.maxDepth);
    }

    public void addFullMBeanInfo(MBeanServerConnection pConn, Map<String, Object> pMBeanMap, ObjectName pObjectName, MBeanInfo pMBeanInfo, ObjectName pName, Set<DataUpdater> customUpdaters) {
        JSONObject cached = this.cache != null ? this.cache.get(pObjectName) : null;
        JSONObject cachedWithoutOpenType = this.noOpenTypeCache != null ? this.noOpenTypeCache.get(pObjectName) : null;
        boolean updaterFound = false;
        for (DataUpdater updater : UPDATERS.values()) {
            String key = updater.getKey();
            if (this.selectedUpdater != null && !key.equals(this.selectedUpdater)) continue;
            if (this.listOpenTypes && cached != null && cached.containsKey(key)) {
                pMBeanMap.put(key, cached.get(key));
            } else if (!this.listOpenTypes && cachedWithoutOpenType != null && cachedWithoutOpenType.containsKey(key)) {
                pMBeanMap.put(key, cachedWithoutOpenType.get(key));
            } else if (updater instanceof OpenTypeAwareDataUpdate) {
                OpenTypeAwareDataUpdate updater2 = (OpenTypeAwareDataUpdate)((Object)updater);
                updater2.update(pMBeanMap, pObjectName, pMBeanInfo, null, this.listOpenTypes);
            } else {
                updater.update(pMBeanMap, pObjectName, pMBeanInfo, null);
            }
            updaterFound = true;
        }
        if (this.listKeys && (this.selectedUpdater == null || LIST_KEYS_UPDATER.getKey().equals(this.selectedUpdater))) {
            LIST_KEYS_UPDATER.update(pMBeanMap, pObjectName, pMBeanInfo, null);
            updaterFound = true;
        }
        if (this.listInterfaces && (this.selectedUpdater == null || LIST_INTERFACES_UPDATER.getKey().equals(this.selectedUpdater)) && pConn instanceof MBeanServer) {
            MBeanServer mBeanServer = (MBeanServer)pConn;
            LIST_INTERFACES_UPDATER.update(mBeanServer, pMBeanMap, pObjectName, pMBeanInfo, null);
            updaterFound = true;
        }
        for (DataUpdater customUpdater : customUpdaters) {
            if (this.selectedUpdater != null && !customUpdater.getKey().equals(this.selectedUpdater)) continue;
            if (customUpdater instanceof OpenTypeAwareDataUpdate) {
                OpenTypeAwareDataUpdate updater2 = (OpenTypeAwareDataUpdate)((Object)customUpdater);
                customUpdater.update(pMBeanMap, pObjectName, pMBeanInfo, null, this.listOpenTypes);
            } else {
                customUpdater.update(pMBeanMap, pObjectName, pMBeanInfo, null);
            }
            updaterFound = true;
        }
        if (!updaterFound) {
            throw new IllegalArgumentException("Illegal path element for updater selection: " + this.selectedUpdater);
        }
    }

    private JSONObject getOrCreateJSONObject(Map<String, Object> pMap, String pKey) {
        JSONObject nMap = (JSONObject)pMap.get(pKey);
        if (nMap == null) {
            nMap = new JSONObject();
            pMap.put(pKey, nMap);
        }
        return nMap;
    }

    private Object truncateJSONObject(JSONObject pValue, int pMaxDepth) {
        if (pMaxDepth == 0) {
            return 1;
        }
        JSONObject ret = new JSONObject();
        Set entries = pValue.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof JSONObject) {
                ret.put(key, this.truncateJSONObject((JSONObject)value, pMaxDepth - 1));
                continue;
            }
            ret.put(key, value);
        }
        return ret;
    }

    private Object navigatePath() {
        JSONObject innerMap = this.infoMap;
        if (!this.listCache) {
            for (int size = this.retrieveAtDepth; size > 0; --size) {
                Collection vals = innerMap.values();
                if (vals.isEmpty()) {
                    return innerMap;
                }
                if (vals.size() != 1) {
                    throw new IllegalStateException("Internal: More than one key found when extracting with path: " + String.valueOf(vals));
                }
                Object value = vals.iterator().next();
                if (size == 1) {
                    return value;
                }
                if (!(value instanceof JSONObject)) {
                    throw new IllegalStateException("Internal: Value within path extraction must be a Map, not " + String.valueOf(value.getClass()));
                }
                innerMap = (JSONObject)value;
            }
        }
        return innerMap;
    }

    static {
        for (DataUpdater updater : new DataUpdater[]{new DescriptionDataUpdater(), new ClassNameDataUpdater(), new ConstructorDataUpdater(), new AttributeDataUpdater(), new OperationDataUpdater(), new NotificationDataUpdater()}) {
            UPDATERS.put(updater.getKey(), updater);
        }
    }
}

