/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler.list;

import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jolokia.json.JSONArray;
import org.jolokia.server.core.service.api.DataUpdater;
import org.jolokia.service.jmx.handler.list.DataKeys;

class ListInterfacesDataUpdater
extends DataUpdater {
    protected ListInterfacesDataUpdater() {
        super(100);
    }

    @Override
    public String getKey() {
        return DataKeys.INTERFACES.getKey();
    }

    public void update(MBeanServer mBeanServer, Map<String, Object> pMap, ObjectName pObjectName, MBeanInfo pMBeanInfo, Deque<String> pPathStack) {
        try {
            ClassLoader loader = mBeanServer.getClassLoaderFor(pObjectName);
            String className = pMBeanInfo.getClassName();
            Class<?> clazz = loader == null ? Class.forName(className) : Class.forName(className, false, loader);
            HashSet interfaces = new HashSet();
            this.collectInterfaces(clazz, interfaces);
            pMap.put(this.getKey(), new JSONArray((Collection<?>)interfaces.stream().map(Class::getName).collect(Collectors.toList())));
        }
        catch (ClassNotFoundException | InstanceNotFoundException exception) {
            // empty catch block
        }
    }

    private void collectInterfaces(Class<?> clazz, Set<Class<?>> interfaces) {
        if (clazz == null) {
            return;
        }
        if (clazz.isInterface()) {
            interfaces.add(clazz);
        } else {
            this.collectInterfaces(clazz.getSuperclass(), interfaces);
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            this.collectInterfaces(iface, interfaces);
        }
    }
}

