/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler.list;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenType;
import org.jolokia.converter.object.OpenTypeHelper;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.service.api.DataUpdater;
import org.jolokia.server.core.service.api.OpenTypeAwareDataUpdate;
import org.jolokia.service.jmx.handler.list.DataKeys;

class AttributeDataUpdater
extends DataUpdater
implements OpenTypeAwareDataUpdate {
    protected AttributeDataUpdater() {
        super(100);
    }

    @Override
    public String getKey() {
        return DataKeys.ATTRIBUTES.getKey();
    }

    @Override
    public JSONObject extractData(ObjectName pObjectName, MBeanInfo pMBeanInfo, String attribute) {
        JSONObject attrMap = new JSONObject();
        for (MBeanAttributeInfo attrInfo : pMBeanInfo.getAttributes()) {
            if (attribute != null && !attrInfo.getName().equals(attribute)) continue;
            attrMap.put(attrInfo.getName(), AttributeDataUpdater.basicData(attrInfo));
        }
        return attrMap;
    }

    @Override
    public JSONObject extractDataWithOpenTypes(ObjectName pObjectName, MBeanInfo pMBeanInfo, String attribute) {
        JSONObject attrMap = new JSONObject();
        for (MBeanAttributeInfo attrInfo : pMBeanInfo.getAttributes()) {
            if (attribute != null && !attrInfo.getName().equals(attribute)) continue;
            JSONObject map = AttributeDataUpdater.basicData(attrInfo);
            if (attrInfo instanceof OpenMBeanAttributeInfo) {
                OpenMBeanAttributeInfo openMBeanAttributeInfo = (OpenMBeanAttributeInfo)((Object)attrInfo);
                map.put(DataKeys.OPEN_TYPE.getKey(), OpenTypeHelper.toJSON(openMBeanAttributeInfo.getOpenType(), (MBeanFeatureInfo)attrInfo));
            } else {
                OpenType<?> openType = OpenTypeHelper.findOpenType(attrInfo.getDescriptor());
                if (openType != null) {
                    map.put(DataKeys.OPEN_TYPE.getKey(), OpenTypeHelper.toJSON(openType, (MBeanFeatureInfo)attrInfo));
                }
            }
            attrMap.put(attrInfo.getName(), map);
        }
        return attrMap;
    }

    private static JSONObject basicData(MBeanAttributeInfo attrInfo) {
        JSONObject map = new JSONObject();
        map.put(DataKeys.TYPE.getKey(), attrInfo.getType());
        map.put(DataKeys.DESCRIPTION.getKey(), attrInfo.getDescription());
        map.put(DataKeys.READ.getKey(), attrInfo.isReadable());
        map.put(DataKeys.WRITE.getKey(), attrInfo.isWritable());
        map.put(DataKeys.READ_WRITE.getKey(), attrInfo.isWritable() && attrInfo.isReadable());
        map.put(DataKeys.IS.getKey(), attrInfo.isIs());
        return map;
    }
}

