/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenType;
import org.jolokia.server.core.request.BadRequestException;
import org.jolokia.server.core.request.JolokiaWriteRequest;
import org.jolokia.server.core.service.serializer.Serializer;
import org.jolokia.server.core.util.RequestType;
import org.jolokia.service.jmx.handler.AbstractCommandHandler;

public class WriteHandler
extends AbstractCommandHandler<JolokiaWriteRequest> {
    @Override
    public RequestType getType() {
        return RequestType.WRITE;
    }

    @Override
    protected void checkForRestriction(JolokiaWriteRequest pRequest) {
        if (!this.context.isAttributeWriteAllowed(pRequest.getObjectName(), pRequest.getAttributeName())) {
            throw new SecurityException("Writing attribute " + pRequest.getAttributeName() + " forbidden for MBean " + pRequest.getObjectNameAsString());
        }
    }

    @Override
    public Object doHandleSingleServerRequest(MBeanServerConnection server, JolokiaWriteRequest request) throws IOException, JMException, BadRequestException {
        Values values;
        Object currentAttributeValue;
        MBeanInfo mInfo = server.getMBeanInfo(request.getObjectName());
        MBeanAttributeInfo aInfo = null;
        for (MBeanAttributeInfo i : mInfo.getAttributes()) {
            if (!i.getName().equals(request.getAttributeName())) continue;
            aInfo = i;
            break;
        }
        if (aInfo == null) {
            throw new AttributeNotFoundException("No such attribute: " + request.getAttributeName());
        }
        if (!aInfo.isWritable()) {
            throw new AttributeNotFoundException("Can't write attribute: " + request.getAttributeName());
        }
        boolean writeOnly = !aInfo.isReadable();
        Object object = currentAttributeValue = writeOnly ? null : server.getAttribute(request.getObjectName(), request.getAttributeName());
        if (aInfo instanceof OpenMBeanAttributeInfo) {
            OpenMBeanAttributeInfo info = (OpenMBeanAttributeInfo)((Object)aInfo);
            values = this.getOpenTypeAttribute(info.getOpenType(), currentAttributeValue, request);
        } else {
            values = this.handleGenericAttribute(aInfo.getType(), currentAttributeValue, request);
        }
        Attribute attribute = new Attribute(request.getAttributeName(), values.newValue);
        server.setAttribute(request.getObjectName(), attribute);
        return values.oldValue;
    }

    private Values getOpenTypeAttribute(OpenType<?> pOpenType, Object pCurrentValue, JolokiaWriteRequest pRequest) throws BadRequestException {
        if (pRequest.getPathParts() != null && !pRequest.getPathParts().isEmpty()) {
            throw new IllegalArgumentException("Cannot set value for OpenType " + String.valueOf(pOpenType) + " with inner path " + pRequest.getPath() + " since OpenTypes are immutable");
        }
        try {
            Object newValue = this.context.getMandatoryService(Serializer.class).deserializeOpenType(pOpenType, pRequest.getValue());
            return new Values(newValue, pCurrentValue);
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            throw new BadRequestException("Can't process " + String.valueOf(pRequest) + ": " + e.getMessage(), e);
        }
    }

    private Values handleGenericAttribute(String pType, Object pCurrentValue, JolokiaWriteRequest pRequest) throws JMException, BadRequestException {
        List<String> pathParts = pRequest.getPathParts();
        Object newValue = pRequest.getValue();
        if (pathParts != null && !pathParts.isEmpty() && pCurrentValue == null) {
            throw new IllegalArgumentException("Cannot set value with path when parent object is not set");
        }
        try {
            if (pathParts != null && !pathParts.isEmpty()) {
                Object oldInnerValue;
                try {
                    oldInnerValue = this.context.getMandatoryService(Serializer.class).setInnerValue(pCurrentValue, newValue, pathParts);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new JMRuntimeException(e.getMessage());
                }
                return new Values(pCurrentValue, oldInnerValue);
            }
            return new Values(this.context.getMandatoryService(Serializer.class).deserialize(pType, newValue), pCurrentValue);
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            throw new BadRequestException("Can't process " + String.valueOf(pRequest) + ": " + e.getMessage(), e);
        }
    }

    private record Values(Object newValue, Object oldValue) {
    }
}

