/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.core.service.serializer.ValueFaultHandler;
import org.jolokia.server.core.request.JolokiaReadRequest;
import org.jolokia.server.core.util.RequestType;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.service.jmx.handler.AbstractCommandHandler;

public class ReadHandler
extends AbstractCommandHandler<JolokiaReadRequest> {
    private static final MBeanServerAccess.MBeanAction<MBeanInfo> MBEAN_INFO_ACTION = new MBeanServerAccess.MBeanAction<MBeanInfo>(){

        @Override
        public MBeanInfo execute(MBeanServerConnection pConn, ObjectName pName, Object ... extraArgs) throws IOException, ReflectionException, InstanceNotFoundException, IntrospectionException {
            return pConn.getMBeanInfo(pName);
        }
    };
    private static final MBeanServerAccess.MBeanAction<Object> MBEAN_ATTRIBUTE_READ_HANDLER = new MBeanServerAccess.MBeanAction<Object>(){

        @Override
        public Object execute(MBeanServerConnection pConn, ObjectName pName, Object ... extraArgs) throws IOException, ReflectionException, InstanceNotFoundException, MBeanException, AttributeNotFoundException {
            String attribute = (String)extraArgs[0];
            return pConn.getAttribute(pName, attribute);
        }
    };
    private static final MBeanServerAccess.MBeanAction<AttributeList> MBEAN_ATTRIBUTES_READ_HANDLER = new MBeanServerAccess.MBeanAction<AttributeList>(){

        @Override
        public AttributeList execute(MBeanServerConnection pConn, ObjectName pName, Object ... extraArgs) throws IOException, ReflectionException, InstanceNotFoundException {
            return pConn.getAttributes(pName, (String[])extraArgs);
        }
    };

    @Override
    public RequestType getType() {
        return RequestType.READ;
    }

    @Override
    protected void checkForRestriction(JolokiaReadRequest pRequest) {
    }

    @Override
    public boolean handleAllServersAtOnce(JolokiaReadRequest pRequest) {
        return pRequest.getObjectName().isPattern() || pRequest.isMultiAttributeMode();
    }

    @Override
    public Object doHandleSingleServerRequest(MBeanServerConnection pServer, JolokiaReadRequest pRequest) throws IOException, JMException {
        this.checkRestriction(pRequest.getObjectName(), pRequest.getAttributeName());
        return pServer.getAttribute(pRequest.getObjectName(), pRequest.getAttributeName());
    }

    @Override
    public Object doHandleAllServerRequest(MBeanServerAccess jmxAccess, JolokiaReadRequest pRequest, Object pPreviousResult) throws IOException, JMException {
        ObjectName oName = pRequest.getObjectName();
        ValueFaultHandler faultHandler = pRequest.getValueFaultHandler();
        if (oName.isPattern()) {
            return this.fetchAttributesForMBeanPattern(jmxAccess, oName, pRequest, faultHandler);
        }
        return this.fetchAttributesForMBean(jmxAccess, oName, pRequest, faultHandler, pRequest.isMultiAttributeMode() ? ResolveMode.ALL_REQUESTED : ResolveMode.STRICT);
    }

    private Map<String, Object> fetchAttributesForMBeanPattern(MBeanServerAccess jmxAccess, ObjectName pName, JolokiaReadRequest pRequest, ValueFaultHandler faultHandler) throws IOException, JMException {
        Set<ObjectName> names = this.searchMBeans(jmxAccess, pName);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (ObjectName name : names) {
            try {
                String key = pRequest.getOrderedObjectName(name);
                Map<String, Object> values = this.fetchAttributesForMBean(jmxAccess, name, pRequest, faultHandler, ResolveMode.FILTERED);
                if (values.isEmpty()) continue;
                result.put(key, values);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {}
        }
        if (result.isEmpty()) {
            throw new AttributeNotFoundException("No attribute found for any MBean matching " + String.valueOf(pName) + " pattern");
        }
        return result;
    }

    private Map<String, Object> fetchAttributesForMBean(MBeanServerAccess jmxAccess, ObjectName pName, JolokiaReadRequest pRequest, ValueFaultHandler pFaultHandler, ResolveMode pMode) throws IOException, JMException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        List<String> attributes = this.resolveAttributes(jmxAccess, pName, pRequest, pMode, pFaultHandler);
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        boolean allFetched = false;
        if (attributes.size() > 1) {
            try {
                AttributeList allAttributes = this.getAttributes(jmxAccess, pName, (String[])attributes.toArray(String[]::new));
                for (Attribute a : allAttributes.asList()) {
                    mapping.put(a.getName(), a.getValue());
                }
                allFetched = attributes.size() == mapping.size();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        for (String attribute : attributes) {
            try {
                this.checkRestriction(pName, attribute);
                if (allFetched) {
                    result.put(attribute, mapping.get(attribute));
                    continue;
                }
                if (mapping.containsKey(attribute)) {
                    result.put(attribute, mapping.get(attribute));
                    continue;
                }
                result.put(attribute, this.getAttribute(jmxAccess, pName, attribute));
            }
            catch (IOException e) {
                result.put(attribute, pFaultHandler.handleException(e));
            }
            catch (JMException e) {
                result.put(attribute, pFaultHandler.handleException(e));
            }
            catch (RuntimeException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof UnsupportedOperationException) {
                    UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
                    result.put(attribute, pFaultHandler.handleException(unsupportedOperationException));
                    continue;
                }
                result.put(attribute, pFaultHandler.handleException(e));
            }
        }
        return result;
    }

    private void checkRestriction(ObjectName mBeanName, String attribute) {
        if (!this.context.isAttributeReadAllowed(mBeanName, attribute)) {
            throw new SecurityException("Reading attribute " + attribute + " is forbidden for MBean " + mBeanName.getCanonicalName());
        }
    }

    private Set<ObjectName> searchMBeans(MBeanServerAccess pServerManager, ObjectName pObjectName) throws IOException, InstanceNotFoundException {
        Set<ObjectName> names = pServerManager.queryNames(pObjectName);
        if (names.isEmpty()) {
            throw new InstanceNotFoundException("No MBean with pattern " + String.valueOf(pObjectName) + " found for READ request");
        }
        return names;
    }

    private List<String> resolveAttributes(MBeanServerAccess jmxAccess, ObjectName pName, JolokiaReadRequest pRequest, ResolveMode pMode, ValueFaultHandler pFaultHandler) throws IOException, JMException {
        List<String> attributes;
        List<String> list = attributes = pRequest.isMultiAttributeMode() ? pRequest.getAttributeNames() : Collections.singletonList(pRequest.getAttributeName());
        if (pMode == ResolveMode.ALL_REQUESTED && !attributes.isEmpty()) {
            return attributes;
        }
        List<String> allAvailable = this.getMBeanAttributeNames(jmxAccess, pName);
        if (attributes.isEmpty()) {
            return allAvailable;
        }
        LinkedHashSet<String> available = new LinkedHashSet<String>(allAvailable);
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> unknown = new ArrayList<String>();
        for (String name : attributes) {
            if (available.contains(name)) {
                result.add(name);
                continue;
            }
            unknown.add(name);
        }
        if (pMode == ResolveMode.STRICT && !unknown.isEmpty()) {
            pFaultHandler.handleException(new AttributeNotFoundException("MBean " + String.valueOf(pName) + " doesn't contain required attributes: " + String.join((CharSequence)", ", unknown)));
        }
        return result;
    }

    private List<String> getMBeanAttributeNames(MBeanServerAccess jmxAccess, ObjectName pName) throws IOException, JMException {
        MBeanInfo mBeanInfo = jmxAccess.call(pName, MBEAN_INFO_ACTION, new Object[0]);
        ArrayList<String> ret = new ArrayList<String>();
        for (MBeanAttributeInfo attrInfo : mBeanInfo.getAttributes()) {
            if (!attrInfo.isReadable()) continue;
            ret.add(attrInfo.getName());
        }
        return ret;
    }

    private Object getAttribute(MBeanServerAccess pServerManager, ObjectName pMBeanName, String attribute) throws IOException, JMException {
        return pServerManager.call(pMBeanName, MBEAN_ATTRIBUTE_READ_HANDLER, attribute);
    }

    private AttributeList getAttributes(MBeanServerAccess jmxAccess, ObjectName pName, String[] attributes) throws IOException, JMException {
        return jmxAccess.call(pName, MBEAN_ATTRIBUTES_READ_HANDLER, attributes);
    }

    private static enum ResolveMode {
        STRICT,
        ALL_REQUESTED,
        FILTERED;

    }
}

