/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jolokia.core.util.EscapeUtil;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.request.BadRequestException;
import org.jolokia.server.core.request.JolokiaListRequest;
import org.jolokia.server.core.request.JolokiaRequestFactory;
import org.jolokia.server.core.request.NotChangedException;
import org.jolokia.server.core.request.ProcessingParameters;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.util.ProviderUtil;
import org.jolokia.server.core.util.RequestType;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.service.jmx.handler.AbstractCommandHandler;
import org.jolokia.service.jmx.handler.ListMBeanEachAction;
import org.jolokia.service.jmx.handler.list.MBeanInfoData;

public class ListHandler
extends AbstractCommandHandler<JolokiaListRequest> {
    private MBeanServerAccess jmxAccess;
    private final Map<ObjectName, JSONObject> cache = new ConcurrentHashMap<ObjectName, JSONObject>();
    private final Map<ObjectName, JSONObject> noOpenTypeCache = new ConcurrentHashMap<ObjectName, JSONObject>();

    @Override
    public RequestType getType() {
        return RequestType.LIST;
    }

    @Override
    public void init(JolokiaContext pContext, String pProvider) {
        super.init(pContext, pProvider);
        this.jmxAccess = pContext.getMBeanServerAccess();
        this.cachePlatformMbeans();
    }

    @Override
    protected void checkForRestriction(JolokiaListRequest pRequest) {
        this.checkType();
    }

    @Override
    public boolean handleAllServersAtOnce(JolokiaListRequest pRequest) {
        return true;
    }

    @Override
    public Object doHandleSingleServerRequest(MBeanServerConnection server, JolokiaListRequest request) {
        throw new UnsupportedOperationException("Internal: Method must not be called when all MBeanServers are handled at once");
    }

    @Override
    public Object doHandleAllServerRequest(MBeanServerAccess pServerManager, JolokiaListRequest pRequest, Object pPreviousResult) throws IOException, JMException, BadRequestException, NotChangedException {
        this.checkForModifiedSince(pServerManager, pRequest);
        Deque<String> originalPathStack = EscapeUtil.reversePath(pRequest.getPathParts());
        try {
            LinkedList<String> pathStack = new LinkedList<String>(originalPathStack);
            ObjectName oName = this.objectNameFromPath(pathStack);
            if (oName != null) {
                if (ProviderUtil.matchesProvider(this.pProvider, oName)) {
                    oName = ProviderUtil.extractProvider(oName).getObjectName();
                } else {
                    return pPreviousResult != null ? pPreviousResult : new JSONObject();
                }
            }
            ListMBeanEachAction action = new ListMBeanEachAction(pRequest, pathStack, this.pProvider, this.context, this.cache, this.noOpenTypeCache);
            if (oName == null || oName.isPattern()) {
                pServerManager.each(oName, action);
            } else {
                pServerManager.call(oName, action, new Object[0]);
            }
            return action.getResult((JSONObject)pPreviousResult);
        }
        catch (MalformedObjectNameException e) {
            throw new BadRequestException("Invalid path within the MBean part given. (Path: " + pRequest.getPath() + ")", e);
        }
    }

    private ObjectName objectNameFromPath(Deque<String> pPathStack) throws MalformedObjectNameException {
        if (pPathStack.isEmpty()) {
            return null;
        }
        LinkedList<String> path = new LinkedList<String>(pPathStack);
        String domain = (String)path.pop();
        if (domain == null) {
            domain = "*";
        }
        if (path.isEmpty()) {
            return new ObjectName(domain + ":*");
        }
        String props = (String)path.pop();
        if (props == null) {
            props = "*";
        }
        return new ObjectName(domain + ":" + props);
    }

    private void cachePlatformMbeans() {
        Set<String> platformMBeans = Set.of(MBeanServerDelegate.DELEGATE_NAME.getCanonicalName(), "java.lang:type=ClassLoading", "java.lang:type=Compilation", "java.lang:type=Memory", "java.lang:type=OperatingSystem", "java.lang:type=Runtime", "java.lang:type=Threading");
        Set<String> platformMBeanGroups = Set.of("java.lang:type=MemoryManager", "java.lang:type=MemoryPool", "java.lang:type=GarbageCollector");
        Set<String> optionalMBeans = Set.of("jdk.management.jfr:type=FlightRecorder", "java.util.logging:type=Logging");
        try {
            JolokiaListRequest list1 = (JolokiaListRequest)JolokiaRequestFactory.createGetRequest("list", new ProcessingParameters(Collections.emptyMap()));
            JolokiaListRequest list2 = (JolokiaListRequest)JolokiaRequestFactory.createGetRequest("list", new ProcessingParameters(Map.of(ConfigKey.OPEN_TYPES, "true")));
            for (JolokiaListRequest list : Arrays.asList(list1, list2)) {
                boolean withOpenTypes = list.getParameterAsBool(ConfigKey.OPEN_TYPES);
                Map<ObjectName, JSONObject> c = withOpenTypes ? this.cache : this.noOpenTypeCache;
                final MBeanInfoData data = new MBeanInfoData(null, null, list, null, null);
                for (String string : platformMBeans) {
                    try {
                        this.jmxAccess.call(ObjectName.getInstance(string), new MBeanServerAccess.MBeanAction<Object>(){

                            @Override
                            public Void execute(MBeanServerConnection jmx, ObjectName objectName, Object ... extraArgs) throws IOException, JMException {
                                data.addMBeanInfo(jmx, new ObjectInstance(objectName, null), Collections.emptySet(), Collections.emptySet());
                                return null;
                            }
                        }, new Object[0]);
                    }
                    catch (IOException | JMException exception) {}
                }
                for (String string : optionalMBeans) {
                    try {
                        this.jmxAccess.call(ObjectName.getInstance(string), new MBeanServerAccess.MBeanAction<Object>(){

                            @Override
                            public Void execute(MBeanServerConnection jmx, ObjectName objectName, Object ... extraArgs) throws IOException, JMException {
                                if (jmx.isRegistered(objectName)) {
                                    data.addMBeanInfo(jmx, new ObjectInstance(objectName, null), Collections.emptySet(), Collections.emptySet());
                                }
                                return null;
                            }
                        }, new Object[0]);
                    }
                    catch (IOException | JMException exception) {}
                }
                for (String string : platformMBeanGroups) {
                    try {
                        for (MBeanServerConnection server : this.jmxAccess.getMBeanServers()) {
                            Set<ObjectName> names = server.queryNames(ObjectName.getInstance(string + ",*"), null);
                            if (names == null || names.isEmpty()) continue;
                            data.addMBeanInfo(server, new ObjectInstance(names.iterator().next(), null), Collections.emptySet(), Collections.emptySet());
                        }
                    }
                    catch (IOException | JMException exception) {}
                }
                Object object = data.applyPath();
                if (object instanceof JSONObject) {
                    JSONObject result = (JSONObject)object;
                    result.forEach((domain, domainData) -> {
                        if (domainData instanceof JSONObject) {
                            JSONObject mBeansData = (JSONObject)domainData;
                            mBeansData.forEach((keys, mBeanData) -> {
                                if (mBeanData instanceof JSONObject) {
                                    JSONObject json = (JSONObject)mBeanData;
                                    try {
                                        ObjectName platformMBeanName = ObjectName.getInstance(domain + ":" + keys);
                                        c.put(platformMBeanName, json);
                                    }
                                    catch (MalformedObjectNameException malformedObjectNameException) {
                                        // empty catch block
                                    }
                                }
                            });
                        }
                    });
                }
                for (String string : platformMBeanGroups) {
                    for (ObjectName cached : c.keySet()) {
                        try {
                            if (!ObjectName.getInstance(string + ",*").apply(cached)) continue;
                            for (MBeanServerConnection server : this.jmxAccess.getMBeanServers()) {
                                boolean found = false;
                                Set<ObjectName> names = server.queryNames(ObjectName.getInstance(string + ",*"), null);
                                for (ObjectName n : names) {
                                    if (c.containsKey(n)) continue;
                                    c.put(n, c.get(cached));
                                }
                            }
                        }
                        catch (IOException | MalformedObjectNameException exception) {
                        }
                    }
                }
            }
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
    }
}

