/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenType;
import org.jolokia.core.service.serializer.ValueFaultHandler;
import org.jolokia.server.core.request.BadRequestException;
import org.jolokia.server.core.request.JolokiaExecRequest;
import org.jolokia.server.core.service.serializer.Serializer;
import org.jolokia.server.core.util.RequestType;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.service.jmx.handler.AbstractCommandHandler;

public class ExecHandler
extends AbstractCommandHandler<JolokiaExecRequest> {
    @Override
    public RequestType getType() {
        return RequestType.EXEC;
    }

    @Override
    protected void checkForRestriction(JolokiaExecRequest pRequest) {
        if (!this.context.isOperationAllowed(pRequest.getObjectName(), pRequest.getOperation())) {
            throw new SecurityException("Operation " + pRequest.getOperation() + " forbidden for MBean " + pRequest.getObjectNameAsString());
        }
    }

    @Override
    public boolean handleAllServersAtOnce(JolokiaExecRequest pRequest) {
        return pRequest.getObjectName().isPattern();
    }

    @Override
    public Object doHandleSingleServerRequest(MBeanServerConnection server, JolokiaExecRequest request) throws IOException, JMException, BadRequestException {
        OperationAndParamType types = this.extractOperationTypes(server, request);
        int nrParams = types.paramClasses.length;
        Object[] params = new Object[nrParams];
        List<Object> args = request.getArguments();
        if (args != null && nrParams < args.size()) {
            ArrayList<Object> trail = new ArrayList<Object>(args.subList(nrParams, args.size()));
            LinkedList<String> path = new LinkedList<String>();
            for (Object e : trail) {
                if (!(e instanceof String)) continue;
                path.add((String)e);
            }
            request.splitArgumentsAndPath(nrParams, path);
            args = request.getArguments();
        } else if (args == null) {
            args = Collections.emptyList();
        }
        this.verifyArguments(request, types, nrParams, args);
        try {
            for (int i = 0; i < nrParams; ++i) {
                params[i] = types.paramOpenTypes[i] != null ? this.context.getMandatoryService(Serializer.class).deserializeOpenType(types.paramOpenTypes[i], args.get(i)) : this.context.getMandatoryService(Serializer.class).deserialize(types.paramClasses[i], args.get(i));
            }
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            throw new BadRequestException("Can't process " + String.valueOf(request), e);
        }
        return server.invoke(request.getObjectName(), types.operationName, params, types.paramClasses);
    }

    @Override
    public Object doHandleAllServerRequest(MBeanServerAccess jmxAccess, JolokiaExecRequest pRequest, Object pPreviousResult) throws JMException, BadRequestException, IOException {
        ObjectName oName = pRequest.getObjectName();
        ValueFaultHandler faultHandler = pRequest.getValueFaultHandler();
        if (oName.isPattern()) {
            Set<ObjectName> names = jmxAccess.queryNames(oName);
            if (names.isEmpty()) {
                throw new InstanceNotFoundException("No MBean with pattern " + String.valueOf(oName) + " found for EXEC request");
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            boolean invokedAtLeastOnce = false;
            block4: for (ObjectName name : names) {
                for (MBeanServerConnection server : jmxAccess.getMBeanServers()) {
                    try {
                        Object singleResult = this.doHandleSingleServerRequest(server, pRequest.withChangedObjectName(name));
                        result.put(pRequest.getOrderedObjectName(name), singleResult);
                        continue block4;
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                    }
                }
            }
            if (result.isEmpty()) {
                throw new InstanceNotFoundException("No MBean found matching " + String.valueOf(oName) + " pattern to invoke " + String.valueOf(pRequest));
            }
            return result;
        }
        for (MBeanServerConnection server : jmxAccess.getMBeanServers()) {
            try {
                return this.doHandleSingleServerRequest(server, pRequest.withChangedObjectName(oName));
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
        }
        throw new InstanceNotFoundException("No " + String.valueOf(oName) + " MBean found to invoke " + String.valueOf(pRequest));
    }

    private void verifyArguments(JolokiaExecRequest request, OperationAndParamType pTypes, int pNrParams, List<?> pArgs) throws BadRequestException {
        if (pNrParams > 0 && pArgs == null || pArgs != null && pArgs.size() != pNrParams) {
            throw new BadRequestException("Invalid number of operation arguments. Operation " + request.getOperation() + " on " + String.valueOf(request.getObjectName()) + " requires " + pTypes.paramClasses.length + " parameters, not " + (pArgs == null ? 0 : pArgs.size()) + " as given");
        }
    }

    private OperationAndParamType extractOperationTypes(MBeanServerConnection pServer, JolokiaExecRequest pRequest) throws IOException, JMException, BadRequestException {
        List<Object> types;
        if (pRequest.getOperation() == null) {
            throw new BadRequestException("No operation given for exec Request on MBean " + String.valueOf(pRequest.getObjectName()));
        }
        List<String> opArgs = this.splitOperation(pRequest.getOperation());
        String operation = opArgs.get(0);
        if (opArgs.size() > 1) {
            types = opArgs.size() == 2 && opArgs.get(1) == null ? Collections.emptyList() : opArgs.subList(1, opArgs.size());
        } else {
            List<MBeanParameterInfo[]> paramInfos = this.extractMBeanParameterInfos(pServer, pRequest, operation);
            if (paramInfos.size() == 1) {
                return new OperationAndParamType(operation, paramInfos.get(0));
            }
            throw new BadRequestException(this.getErrorMessageForMissingSignature(pRequest, operation, paramInfos));
        }
        List<MBeanParameterInfo[]> paramInfos = this.extractMBeanParameterInfos(pServer, pRequest, operation);
        MBeanParameterInfo[] matchingSignature = this.getMatchingSignature(types, paramInfos);
        if (matchingSignature == null) {
            throw new BadRequestException("No operation " + pRequest.getOperation() + " on MBean " + pRequest.getObjectNameAsString() + " exists. Known signatures: " + this.signatureToString(paramInfos));
        }
        return new OperationAndParamType(operation, matchingSignature);
    }

    private List<MBeanParameterInfo[]> extractMBeanParameterInfos(MBeanServerConnection pServer, JolokiaExecRequest pRequest, String pOperation) throws IOException, JMException {
        MBeanInfo mBeanInfo = pServer.getMBeanInfo(pRequest.getObjectName());
        ArrayList<MBeanParameterInfo[]> paramInfos = new ArrayList<MBeanParameterInfo[]>();
        for (MBeanOperationInfo opInfo : mBeanInfo.getOperations()) {
            if (!opInfo.getName().equals(pOperation)) continue;
            paramInfos.add(opInfo.getSignature());
        }
        if (paramInfos.isEmpty()) {
            NoSuchMethodException cause = new NoSuchMethodException(pOperation);
            throw new ReflectionException(cause, cause.getMessage());
        }
        return paramInfos;
    }

    private MBeanParameterInfo[] getMatchingSignature(List<String> pTypes, List<MBeanParameterInfo[]> pParamInfos) {
        block0: for (MBeanParameterInfo[] infos : pParamInfos) {
            if (infos.length == 0 && pTypes.isEmpty()) {
                return infos;
            }
            if (pTypes.size() != infos.length) continue;
            for (int i = 0; i < infos.length; ++i) {
                String type = infos[i].getType();
                if (!type.equals(pTypes.get(i))) continue block0;
            }
            return infos;
        }
        return null;
    }

    private List<String> splitOperation(String pOperation) {
        ArrayList<String> ret = new ArrayList<String>();
        Pattern p = Pattern.compile("^(.*)\\((.*)\\)$");
        Matcher m = p.matcher(pOperation);
        if (m.matches()) {
            ret.add(m.group(1));
            if (!m.group(2).isEmpty()) {
                String[] args = m.group(2).split("\\s*,\\s*");
                ret.addAll(Arrays.asList(args));
            } else {
                ret.add(null);
            }
        } else {
            ret.add(pOperation);
        }
        return ret;
    }

    private String getErrorMessageForMissingSignature(JolokiaExecRequest pRequest, String pOperation, List<MBeanParameterInfo[]> pParamInfos) {
        return "Operation " + pOperation + " on MBean " + pRequest.getObjectNameAsString() + " is overloaded. Signatures found: " + this.signatureToString(pParamInfos) + ". Use a signature when specifying the operation.";
    }

    private String signatureToString(List<MBeanParameterInfo[]> pParamInfos) {
        StringBuilder ret = new StringBuilder();
        for (MBeanParameterInfo[] ii : pParamInfos) {
            ret.append("(");
            for (MBeanParameterInfo i : ii) {
                ret.append(i.getType()).append(",");
            }
            ret.setLength(ret.length() - 1);
            ret.append("),");
        }
        ret.setLength(ret.length() - 1);
        return ret.toString();
    }

    private static final class OperationAndParamType {
        private final String operationName;
        private final String[] paramClasses;
        private final OpenType<?>[] paramOpenTypes;

        private OperationAndParamType(String pOperationName, MBeanParameterInfo[] pParameterInfos) {
            this.operationName = pOperationName;
            this.paramClasses = new String[pParameterInfos.length];
            this.paramOpenTypes = new OpenType[pParameterInfos.length];
            int i = 0;
            for (MBeanParameterInfo info : pParameterInfos) {
                if (info instanceof OpenMBeanParameterInfo) {
                    OpenMBeanParameterInfo openTypeInfo = (OpenMBeanParameterInfo)((Object)info);
                    this.paramOpenTypes[i] = openTypeInfo.getOpenType();
                }
                this.paramClasses[i++] = info.getType();
            }
        }
    }
}

