/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler;

import java.io.IOException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.request.BadRequestException;
import org.jolokia.server.core.request.EmptyResponseException;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.request.NotChangedException;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.service.jmx.api.CommandHandler;

public abstract class AbstractCommandHandler<R extends JolokiaRequest>
implements CommandHandler<R> {
    protected JolokiaContext context;
    protected String pProvider;

    @Override
    public void init(JolokiaContext pContext, String pProvider) {
        this.context = pContext;
        this.pProvider = pProvider;
    }

    @Override
    public boolean handleAllServersAtOnce(R pRequest) {
        return false;
    }

    @Override
    public Object handleSingleServerRequest(MBeanServerConnection pServer, R pRequest) throws IOException, JMException, NotChangedException, BadRequestException, EmptyResponseException {
        this.checkForRestriction(pRequest);
        this.checkHttpMethod(pRequest);
        return this.doHandleSingleServerRequest(pServer, pRequest);
    }

    @Override
    public Object handleAllServerRequest(MBeanServerAccess pServerManager, R pRequest, Object pPreviousResult) throws IOException, JMException, NotChangedException, BadRequestException, EmptyResponseException {
        this.checkForRestriction(pRequest);
        this.checkHttpMethod(pRequest);
        return this.doHandleAllServerRequest(pServerManager, pRequest, pPreviousResult);
    }

    @Override
    public void destroy() throws JMException {
    }

    protected abstract Object doHandleSingleServerRequest(MBeanServerConnection var1, R var2) throws IOException, JMException, NotChangedException, BadRequestException, EmptyResponseException;

    protected Object doHandleAllServerRequest(MBeanServerAccess serverManager, R request, Object pPreviousResult) throws IOException, JMException, NotChangedException, BadRequestException, EmptyResponseException {
        return null;
    }

    protected abstract void checkForRestriction(R var1);

    protected void checkType() {
        if (!this.context.isTypeAllowed(this.getType())) {
            throw new SecurityException("Command type " + String.valueOf((Object)this.getType()) + " not allowed due to policy used");
        }
    }

    private void checkHttpMethod(R pRequest) {
        if (!this.context.isHttpMethodAllowed(((JolokiaRequest)pRequest).getHttpMethod())) {
            throw new SecurityException("HTTP method " + ((JolokiaRequest)pRequest).getHttpMethod().getMethod() + " is not allowed according to the installed security policy");
        }
    }

    protected boolean isObjectNameHidden(ObjectName name) {
        return this.context.isObjectNameHidden(name);
    }

    protected void checkForModifiedSince(MBeanServerAccess pServerManager, JolokiaRequest pRequest) throws NotChangedException {
        int ifModifiedSince = pRequest.getParameterAsInt(ConfigKey.IF_MODIFIED_SINCE);
        if (!pServerManager.hasMBeansListChangedSince(ifModifiedSince)) {
            throw new NotChangedException(pRequest);
        }
    }
}

