/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx;

import java.io.IOException;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanServerConnection;
import javax.management.OperationsException;
import org.jolokia.server.core.request.BadRequestException;
import org.jolokia.server.core.request.EmptyResponseException;
import org.jolokia.server.core.request.JolokiaObjectNameRequest;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.request.NotChangedException;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.request.AbstractRequestHandler;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.service.jmx.api.CommandHandler;
import org.jolokia.service.jmx.api.CommandHandlerManager;

public class LocalRequestHandler
extends AbstractRequestHandler {
    private CommandHandlerManager commandHandlerManager;
    private MBeanServerAccess jmxAccess;

    public LocalRequestHandler(int pOrder) {
        super("jmx", pOrder);
    }

    @Override
    public void init(JolokiaContext pCtx) {
        this.commandHandlerManager = new CommandHandlerManager(pCtx);
        this.jmxAccess = pCtx.getMBeanServerAccess();
    }

    @Override
    public boolean canHandle(JolokiaRequest pJolokiaRequest) {
        if (pJolokiaRequest instanceof JolokiaObjectNameRequest) {
            JolokiaObjectNameRequest objectNameRequest = (JolokiaObjectNameRequest)pJolokiaRequest;
            return objectNameRequest.getProvider() == null || this.checkProvider(objectNameRequest);
        }
        return true;
    }

    @Override
    public <R extends JolokiaRequest> Object handleRequest(R pJmxReq, Object pPreviousResult) throws IOException, JMException, JMRuntimeException, NotChangedException, BadRequestException, EmptyResponseException {
        CommandHandler<R> handler = this.commandHandlerManager.getCommandHandler(pJmxReq.getType());
        if (handler.handleAllServersAtOnce(pJmxReq)) {
            return handler.handleAllServerRequest(this.jmxAccess, pJmxReq, pPreviousResult);
        }
        OperationsException thrownIfNoResult = null;
        for (MBeanServerConnection server : this.jmxAccess.getMBeanServers()) {
            try {
                return handler.handleSingleServerRequest(server, pJmxReq);
            }
            catch (AttributeNotFoundException | InstanceNotFoundException ex) {
                thrownIfNoResult = ex;
            }
        }
        if (thrownIfNoResult != null) {
            throw thrownIfNoResult;
        }
        throw new IllegalStateException("No available MBeanServerConnection to send " + String.valueOf(pJmxReq));
    }

    @Override
    public void destroy() throws JMException {
        this.commandHandlerManager.destroy();
    }
}

