/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.history;

import java.io.Serializable;
import java.util.Objects;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.server.core.request.JolokiaExecRequest;
import org.jolokia.server.core.request.JolokiaObjectNameRequest;
import org.jolokia.server.core.request.JolokiaReadRequest;
import org.jolokia.server.core.request.JolokiaWriteRequest;

public class HistoryKey
implements Serializable {
    private static final long serialVersionUID = 42L;
    private final String type;
    private ObjectName mBean;
    private String secondary;
    private final String path;
    private String target;

    HistoryKey(JolokiaReadRequest pJmxRequest) {
        this.init(pJmxRequest);
        if (pJmxRequest.isMultiAttributeMode() && pJmxRequest.getAttributeNames().size() > 1) {
            throw new IllegalArgumentException("A key cannot contain more than one attribute");
        }
        this.type = "attribute";
        Object object = pJmxRequest.isMultiAttributeMode() ? (pJmxRequest.getAttributeNames().isEmpty() ? null : pJmxRequest.getAttributeNames().get(0)) : (this.secondary = pJmxRequest.getAttributeName());
        if (this.secondary == null) {
            this.secondary = "(all)";
        }
        this.path = pJmxRequest.getPath();
    }

    HistoryKey(JolokiaWriteRequest pJmxReq) {
        this.init(pJmxReq);
        this.type = "attribute";
        this.secondary = pJmxReq.getAttributeName();
        this.path = pJmxReq.getPath();
        if (this.secondary == null) {
            throw new IllegalArgumentException(this.type + " name must not be null");
        }
    }

    HistoryKey(JolokiaExecRequest pJmxReq) {
        this.init(pJmxReq);
        this.type = "operation";
        this.secondary = pJmxReq.getOperation();
        this.path = null;
        if (this.secondary == null) {
            throw new IllegalArgumentException(this.type + " name must not be null");
        }
    }

    private void init(JolokiaObjectNameRequest pJmxReq) {
        if (pJmxReq.getObjectNameAsString() == null) {
            throw new IllegalArgumentException("MBean name must not be null");
        }
        if (pJmxReq.getObjectName().isPattern()) {
            throw new IllegalArgumentException("MBean name must not be a pattern");
        }
        this.target = (String)pJmxReq.getOption("targetId");
        this.mBean = pJmxReq.getObjectName();
    }

    public HistoryKey(String pMBean, String pOperation, String pTarget) throws MalformedObjectNameException {
        this.type = "operation";
        this.mBean = new ObjectName(pMBean);
        this.secondary = pOperation;
        this.path = null;
        this.target = this.sanitize(pTarget);
    }

    private String sanitize(String pValue) {
        return "".equals(pValue) ? null : pValue;
    }

    public HistoryKey(String pMBean, String pAttribute, String pPath, String pTarget) throws MalformedObjectNameException {
        this.type = "attribute";
        this.mBean = new ObjectName(pMBean);
        this.secondary = pAttribute;
        this.path = this.sanitize(pPath);
        this.target = this.sanitize(pTarget);
    }

    public boolean isMBeanPattern() {
        return this.mBean.isPattern();
    }

    public boolean matches(HistoryKey pKey) {
        return this.mBean.apply(pKey.mBean);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryKey that = (HistoryKey)o;
        if (!this.mBean.equals(that.mBean)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!this.secondary.equals(that.secondary)) {
            return false;
        }
        if (!Objects.equals(this.target, that.target)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.mBean.hashCode();
        result = 31 * result + this.secondary.hashCode();
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HistoryKey");
        sb.append("{type='").append(this.type).append('\'');
        sb.append(", mBean=").append(this.mBean);
        sb.append(", secondary='").append(this.secondary).append('\'');
        sb.append(", path='").append(this.path).append('\'');
        sb.append(", target='").append(this.target).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

