/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.detector.jee;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jolokia.core.util.ClassUtil;
import org.jolokia.server.core.detector.DefaultServerHandle;
import org.jolokia.server.core.service.api.ServerHandle;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.server.detector.jee.AbstractServerDetector;

public class JettyDetector
extends AbstractServerDetector {
    public JettyDetector(int pOrder) {
        super("jetty", pOrder);
    }

    @Override
    public ServerHandle detect(MBeanServerAccess pMBeanServerAccess) {
        Class serverClass = ClassUtil.classForName("org.mortbay.jetty.Server", false, new ClassLoader[0]);
        if (serverClass != null) {
            return new DefaultServerHandle("Mortbay", this.getName(), this.getVersion(serverClass));
        }
        serverClass = ClassUtil.classForName("org.eclipse.jetty.server.Server", false, new ClassLoader[0]);
        if (serverClass != null) {
            return new DefaultServerHandle("Eclipse", this.getName(), this.getVersion(serverClass));
        }
        return null;
    }

    private String getVersion(Class<?> serverClass) {
        try {
            Method method = serverClass.getMethod("getVersion", new Class[0]);
            if (Modifier.isStatic(method.getModifiers())) {
                return (String)method.invoke(null, new Object[0]);
            }
            Constructor<?> ctr = serverClass.getConstructor(new Class[0]);
            Object server = ctr.newInstance(new Object[0]);
            return (String)method.invoke(server, new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }
}

