/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.vm;

import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.request.BadRequestException;
import org.jolokia.server.core.request.BaseRequestHandler;
import org.jolokia.server.core.request.EmptyResponseException;
import org.jolokia.server.core.request.JolokiaExecRequest;
import org.jolokia.server.core.request.JolokiaListRequest;
import org.jolokia.server.core.request.JolokiaReadRequest;
import org.jolokia.server.core.request.JolokiaRequestFactory;
import org.jolokia.server.core.request.JolokiaWriteRequest;
import org.jolokia.server.core.request.ProcessingParameters;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.util.RequestType;

public class InVmRequestHandler
extends BaseRequestHandler {
    public InVmRequestHandler(JolokiaContext context) {
        super(context);
    }

    public JSONObject handleList(String mbean) throws EmptyResponseException, BadRequestException {
        JolokiaListRequest list = (JolokiaListRequest)JolokiaRequestFactory.createGetRequest(RequestType.LIST.getName() + "/" + this.toPath(mbean), new ProcessingParameters(new HashMap<ConfigKey, String>()));
        return this.executeRequest(list);
    }

    private String toPath(String mbean) {
        if (mbean == null || mbean.isEmpty()) {
            return "";
        }
        return mbean.replaceAll("!", "!!").replaceAll("/", "!/").replaceFirst(":", "/");
    }

    public JSONObject handleRead(String mbean, String attribute) throws EmptyResponseException, BadRequestException {
        JolokiaReadRequest read = (JolokiaReadRequest)JolokiaRequestFactory.createGetRequest(RequestType.READ.getName() + "/" + mbean + "/" + attribute, new ProcessingParameters(new HashMap<ConfigKey, String>()));
        return this.executeRequest(read);
    }

    public JSONObject handleWrite(String mbean, String attribute, Object value) throws EmptyResponseException, BadRequestException {
        JolokiaWriteRequest write = (JolokiaWriteRequest)JolokiaRequestFactory.createGetRequest(RequestType.WRITE.getName() + "/" + mbean + "/" + attribute + "/" + String.valueOf(value), new ProcessingParameters(new HashMap<ConfigKey, String>()));
        return this.executeRequest(write);
    }

    public JSONObject handleExec(String mbean, String operation, Object ... args) throws EmptyResponseException, BadRequestException {
        String path = RequestType.EXEC.getName() + "/" + mbean + "/" + operation;
        if (args != null && args.length > 0) {
            path = path + "/" + Arrays.stream(args).map(Object::toString).collect(Collectors.joining("/"));
        }
        JolokiaExecRequest exec = (JolokiaExecRequest)JolokiaRequestFactory.createGetRequest(path, new ProcessingParameters(new HashMap<ConfigKey, String>()));
        return this.executeRequest(exec);
    }
}

