/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.util.jmx;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;

public class SingleMBeanServerAccess
implements MBeanServerAccess {
    private final MBeanServerConnection connection;

    public SingleMBeanServerAccess(MBeanServerConnection pConnection) {
        this.connection = pConnection;
    }

    @Override
    public Set<MBeanServerConnection> getMBeanServers() {
        return Collections.singleton(this.connection);
    }

    @Override
    public void each(ObjectName pObjectName, MBeanServerAccess.MBeanEachCallback pCallback) throws IOException, JMException {
        boolean pattern = pObjectName != null && pObjectName.isPattern();
        for (ObjectInstance instance : this.connection.queryMBeans(pObjectName, null)) {
            try {
                pCallback.callback(this.connection, instance);
            }
            catch (InstanceNotFoundException exp) {
                if (pattern) continue;
                throw exp;
            }
        }
    }

    @Override
    public <R> R call(ObjectName pObjectName, MBeanServerAccess.MBeanAction<R> pAction, Object ... pExtraArgs) throws IOException, JMException {
        return pAction.execute(this.connection, pObjectName, pExtraArgs);
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName pObjectName) throws IOException {
        return this.connection.queryNames(pObjectName, null);
    }

    @Override
    public boolean hasMBeansListChangedSince(long pTimestamp) {
        return true;
    }
}

