/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.util.jmx;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jolokia.server.core.util.jmx.JmxUtil;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.server.core.util.jmx.MBeanServers;

public class DefaultMBeanServerAccess
implements MBeanServerAccess,
NotificationListener {
    private long lastMBeanRegistrationChange;
    private final MBeanServers mbeanServers;

    public DefaultMBeanServerAccess() {
        this(null);
    }

    public DefaultMBeanServerAccess(Set<MBeanServerConnection> pServers) {
        this.mbeanServers = new MBeanServers(pServers, this);
        this.registerForMBeanNotifications(this.mbeanServers);
    }

    @Override
    public Set<MBeanServerConnection> getMBeanServers() {
        return this.mbeanServers.getMBeanServers();
    }

    @Override
    public void each(ObjectName pObjectName, MBeanServerAccess.MBeanEachCallback pCallback) throws IOException, JMException {
        boolean pattern = pObjectName != null && pObjectName.isPattern();
        InstanceNotFoundException instanceNotFoundException = null;
        HashSet<ObjectName> visited = new HashSet<ObjectName>();
        for (MBeanServerConnection server : this.getMBeanServers()) {
            for (ObjectInstance instance : server.queryMBeans(pObjectName, null)) {
                if (visited.contains(instance.getObjectName())) continue;
                try {
                    pCallback.callback(server, instance);
                    visited.add(instance.getObjectName());
                }
                catch (InstanceNotFoundException exp) {
                    if (pattern) continue;
                    instanceNotFoundException = exp;
                }
            }
        }
        if (!pattern && instanceNotFoundException != null) {
            throw instanceNotFoundException;
        }
    }

    public <T> T call(ObjectName pObjectName, MBeanServerAccess.MBeanAction<T> pAction, Object ... pExtraArgs) throws IOException, JMException {
        InstanceNotFoundException instanceNotFoundException = null;
        for (MBeanServerConnection server : this.getMBeanServers()) {
            try {
                return pAction.execute(server, pObjectName, pExtraArgs);
            }
            catch (InstanceNotFoundException exp) {
                instanceNotFoundException = exp;
            }
        }
        throw (InstanceNotFoundException)Objects.requireNonNull(instanceNotFoundException);
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName pObjectName) throws IOException {
        LinkedHashSet<ObjectName> names = new LinkedHashSet<ObjectName>();
        for (MBeanServerConnection server : this.getMBeanServers()) {
            names.addAll(server.queryNames(pObjectName, null));
        }
        return names;
    }

    @Override
    public boolean hasMBeansListChangedSince(long pTimestamp) {
        return this.lastMBeanRegistrationChange / 1000L >= pTimestamp;
    }

    @Override
    public void handleNotification(Notification pNotification, Object pHandback) {
        this.lastMBeanRegistrationChange = System.currentTimeMillis();
    }

    protected MBeanServerConnection getJolokiaMBeanServer() {
        return this.mbeanServers.getJolokiaMBeanServer();
    }

    private void registerForMBeanNotifications(MBeanServers pServers) {
        Exception lastExp = null;
        StringBuilder errors = new StringBuilder();
        for (MBeanServerConnection server : pServers.getMBeanServers()) {
            try {
                JmxUtil.addMBeanRegistrationListener(server, this, null);
            }
            catch (IllegalStateException e) {
                lastExp = this.updateErrorMsg(errors, e);
            }
        }
        if (lastExp != null) {
            throw new IllegalStateException(errors.substring(0, errors.length() - 1), lastExp);
        }
    }

    public void unregisterFromMBeanNotifications() {
        Set<MBeanServerConnection> servers = this.getMBeanServers();
        Exception lastExp = null;
        StringBuilder errors = new StringBuilder();
        for (MBeanServerConnection server : servers) {
            try {
                JmxUtil.removeMBeanRegistrationListener(server, this);
            }
            catch (IllegalStateException e) {
                lastExp = this.updateErrorMsg(errors, e);
            }
        }
        if (lastExp != null) {
            throw new IllegalStateException(errors.substring(0, errors.length() - 1), lastExp);
        }
        this.mbeanServers.destroy();
    }

    private Exception updateErrorMsg(StringBuilder pErrors, Exception exp) {
        pErrors.append(exp.getClass()).append(": ").append(exp.getMessage()).append("\n");
        return exp;
    }

    public String dumpMBeanServers() {
        return this.mbeanServers.dump();
    }
}

