/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.util;

import java.util.HashMap;
import java.util.Map;

public enum RequestType {
    READ("read"),
    LIST("list"),
    WRITE("write"),
    EXEC("exec"),
    VERSION("version"),
    CONFIG("config"),
    SEARCH("search"),
    NOTIFICATION("notification");

    private final String name;
    private static final Map<String, RequestType> typesByNameMap;

    private RequestType(String pName) {
        this.name = pName;
    }

    public String getName() {
        return this.name;
    }

    public static RequestType getTypeByName(String pName) {
        if (pName == null) {
            throw new IllegalArgumentException("No type given");
        }
        RequestType type = typesByNameMap.get(pName.toLowerCase());
        if (type == null) {
            throw new IllegalArgumentException("No type with name '" + pName + "' exists");
        }
        return type;
    }

    static {
        typesByNameMap = new HashMap<String, RequestType>();
        for (RequestType t : RequestType.values()) {
            typesByNameMap.put(t.getName(), t);
        }
    }
}

