/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.util;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jolokia.core.api.LogHandler;
import org.jolokia.server.core.service.api.JolokiaService;
import org.jolokia.server.core.service.impl.QuietLogHandler;

public class JolokiaServicesValidator {
    private static boolean warningGiven = false;

    private JolokiaServicesValidator() {
    }

    public static <T> boolean validateServices(Collection<T> services, LogHandler logHandler) {
        if (logHandler == null) {
            logHandler = new QuietLogHandler();
        }
        if (ClassLoader.getSystemClassLoader() != null) {
            try {
                Class<?> c = ClassLoader.getSystemClassLoader().loadClass(JolokiaService.class.getName());
                if (c != JolokiaService.class && !warningGiven) {
                    logHandler.error("org.jolokia.server.core.service.api.JolokiaService interface is available from multiple class loaders:", null);
                    ClassLoader cl1 = JolokiaService.class.getClassLoader();
                    ClassLoader cl2 = c.getClassLoader();
                    logHandler.error(" - " + (cl1 == null ? "Bootstrap ClassLoader" : cl1.toString()), null);
                    logHandler.error(" - " + (cl2 == null ? "Bootstrap ClassLoader" : cl2.toString()), null);
                    logHandler.error("Possible reason: Multiple Jolokia agents are installed while only a single agent per runtime is supported.", null);
                    logHandler.error("Possible effect: Jolokia service discovery may not work correctly.", null);
                    if (!(logHandler instanceof QuietLogHandler)) {
                        warningGiven = true;
                    }
                }
            }
            catch (ClassNotFoundException c) {
                // empty catch block
            }
        }
        LinkedHashSet jolokiaInterfaces = new LinkedHashSet();
        jolokiaInterfaces.add(JolokiaService.class);
        Class theJolokiaServiceClass = (Class)jolokiaInterfaces.iterator().next();
        for (T service : services) {
            if (JolokiaServicesValidator.collectJolokiaServiceInterfaces(service, jolokiaInterfaces, theJolokiaServiceClass) <= 0) continue;
            logHandler.error("Service " + service.getClass().getName() + " loaded from " + String.valueOf(service.getClass().getClassLoader()) + " uses incompatible JolokiaService interface", null);
        }
        return jolokiaInterfaces.size() == 1;
    }

    private static int collectJolokiaServiceInterfaces(Object service, Set<Class<?>> jolokiaInterfaces, Class<?> expected) {
        int count = 0;
        for (Class<?> c = service == null ? null : (service.getClass() == Class.class ? (Class<?>)service : service.getClass()); c != null && c != Object.class; c = c.getSuperclass()) {
            for (Class<?> iface : c.getInterfaces()) {
                if (iface.getName().equals(JolokiaService.class.getName()) && (jolokiaInterfaces.add(iface) || iface != expected)) {
                    ++count;
                }
                if (JolokiaServicesValidator.collectJolokiaServiceInterfaces(iface, jolokiaInterfaces, expected) <= 0) continue;
                ++count;
            }
        }
        return count;
    }
}

