/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.service.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.api.JolokiaService;
import org.jolokia.server.core.service.api.JolokiaServiceLookup;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class OsgiJolokiaServiceFactory
implements JolokiaServiceLookup {
    private final BundleContext context;
    private final Map<Class<? extends JolokiaService<?>>, ServiceTracker<JolokiaService<?>, JolokiaService<?>>> serviceTrackerMap;
    private JolokiaContext jolokiaContext;

    public OsgiJolokiaServiceFactory(BundleContext pCtx) {
        this.context = pCtx;
        this.serviceTrackerMap = new HashMap();
    }

    @Override
    public <T extends JolokiaService<?>> Set<T> getServices(Class<T> pType) {
        ServiceTracker<JolokiaService<?>, JolokiaService<?>> tracker = this.getServiceTracker(pType);
        Object[] services = tracker.getServices();
        if (services != null) {
            TreeSet<JolokiaService> ret = new TreeSet<JolokiaService>();
            for (Object service : services) {
                ret.add((JolokiaService)service);
            }
            return ret;
        }
        return Collections.emptySet();
    }

    private <T extends JolokiaService<?>> ServiceTracker<JolokiaService<?>, JolokiaService<?>> getServiceTracker(Class<T> pType) {
        ServiceTracker<JolokiaService<?>, JolokiaService<?>> tracker = this.serviceTrackerMap.get(pType);
        if (tracker == null) {
            tracker = this.initTracker(pType);
        }
        return tracker;
    }

    private <T extends JolokiaService<?>> ServiceTracker<JolokiaService<?>, JolokiaService<?>> initTracker(Class<T> pType) {
        ServiceTracker tracker = new ServiceTracker(this.context, pType.getName(), (ServiceTrackerCustomizer)new JolokiaServiceTrackerCustomizer());
        this.serviceTrackerMap.put(pType, tracker);
        tracker.open();
        return tracker;
    }

    @Override
    public void init(JolokiaContext pJolokiaContext) {
        this.jolokiaContext = pJolokiaContext;
        this.initTracker(JolokiaService.class);
    }

    @Override
    public void destroy() {
        for (ServiceTracker<JolokiaService<?>, JolokiaService<?>> tracker : this.serviceTrackerMap.values()) {
            tracker.close();
        }
    }

    private class JolokiaServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<JolokiaService<?>, JolokiaService<?>> {
        private JolokiaServiceTrackerCustomizer() {
        }

        public JolokiaService<?> addingService(ServiceReference<JolokiaService<?>> reference) {
            JolokiaService jolokiaService = (JolokiaService)OsgiJolokiaServiceFactory.this.context.getService(reference);
            if (jolokiaService != null) {
                if (OsgiJolokiaServiceFactory.this.jolokiaContext != null) {
                    jolokiaService.init(OsgiJolokiaServiceFactory.this.jolokiaContext);
                } else {
                    throw new ServiceException("Cannot initialize service \"" + String.valueOf(jolokiaService) + "\" since the JolokiaContext is not yet initialized");
                }
            }
            return jolokiaService;
        }

        public void modifiedService(ServiceReference<JolokiaService<?>> reference, JolokiaService<?> service) {
        }

        public void removedService(ServiceReference<JolokiaService<?>> reference, JolokiaService<?> service) {
            try {
                JolokiaService<?> jolokiaService = service;
                OsgiJolokiaServiceFactory.this.context.ungetService(reference);
                jolokiaService.destroy();
            }
            catch (Exception e) {
                throw new ServiceException("destroy() on JolokiaService " + String.valueOf(service) + " failed" + e.getMessage(), (Throwable)e);
            }
        }
    }
}

