/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.service.api;

import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;

public class SecurityDetails {
    private final JSONObject details = new JSONObject();
    private final JSONArray methods = new JSONArray();

    public SecurityDetails() {
        this.details.put("authentication", this.methods);
    }

    public void registerAuthenticationMethod(AuthMethod method, String realm) {
        JSONObject m = new JSONObject();
        m.put("method", method.method());
        if (realm != null && !realm.isEmpty()) {
            m.put("realm", realm);
        }
        this.methods.add(m);
    }

    public JSONObject toJSONObject() {
        return this.details;
    }

    public static enum AuthMethod {
        BASIC("basic"),
        MTLS("mtls");

        private final String method;

        private AuthMethod(String method) {
            this.method = method;
        }

        public String method() {
            return this.method;
        }
    }
}

