/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.restrictor;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.jolokia.core.api.LogHandler;
import org.jolokia.core.util.ClassUtil;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.config.Configuration;
import org.jolokia.server.core.restrictor.AllowAllRestrictor;
import org.jolokia.server.core.restrictor.DenyAllRestrictor;
import org.jolokia.server.core.restrictor.policy.PolicyRestrictor;
import org.jolokia.server.core.service.api.Restrictor;

public final class RestrictorFactory {
    private RestrictorFactory() {
    }

    public static Restrictor createRestrictor(Configuration pConfig, LogHandler log) {
        Restrictor customRestrictor = RestrictorFactory.createCustomRestrictor(pConfig);
        if (customRestrictor != null) {
            log.info("Using restrictor " + customRestrictor.getClass().getCanonicalName());
            return customRestrictor;
        }
        String policyLocation = pConfig.getConfig(ConfigKey.POLICY_LOCATION);
        try {
            PolicyRestrictor ret = RestrictorFactory.lookupPolicyRestrictor(policyLocation);
            if (ret != null) {
                log.info("Using policy access restrictor " + policyLocation);
                return ret;
            }
            log.info("No access restrictor found, access to any MBean is allowed");
            return new AllowAllRestrictor();
        }
        catch (IOException e) {
            log.error("Error while accessing access restrictor at " + policyLocation + ". Denying all access to MBeans for security reasons. Exception: " + e.getMessage(), e);
            return new DenyAllRestrictor();
        }
    }

    private static Restrictor createCustomRestrictor(Configuration pConfig) {
        String restrictorClassName = pConfig.getConfig(ConfigKey.RESTRICTOR_CLASS);
        if (restrictorClassName == null) {
            return null;
        }
        Class restrictorClass = ClassUtil.classForName(restrictorClassName, new ClassLoader[0]);
        if (restrictorClass == null) {
            throw new IllegalArgumentException("No custom restrictor class " + restrictorClassName + " found");
        }
        return RestrictorFactory.lookupRestrictor(pConfig, restrictorClass);
    }

    private static Restrictor lookupRestrictor(Configuration pConfig, Class<?> restrictorClass) {
        try {
            try {
                Constructor<?> ctr = restrictorClass.getConstructor(Configuration.class);
                return (Restrictor)ctr.newInstance(pConfig);
            }
            catch (NoSuchMethodException exp) {
                try {
                    Constructor<?> defaultConstructor = restrictorClass.getConstructor(new Class[0]);
                    return (Restrictor)defaultConstructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException exp2) {
                    throw new IllegalArgumentException("Cannot create custom restrictor for class " + String.valueOf(restrictorClass) + " because neither a constructor with 'Configuration' as only element nor a default constructor is available");
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot create an instance of custom restrictor class " + String.valueOf(restrictorClass), e);
        }
    }

    public static PolicyRestrictor lookupPolicyRestrictor(String pLocation) throws IOException {
        InputStream is;
        if (pLocation.startsWith("classpath:")) {
            String path = pLocation.substring("classpath:".length());
            is = ClassUtil.getResourceAsStream(path);
            if (is == null) {
                is = RestrictorFactory.class.getResourceAsStream(path);
            }
        } else {
            URL url = new URL(pLocation);
            is = url.openStream();
        }
        return is != null ? new PolicyRestrictor(is) : null;
    }
}

