/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.request.notification;

import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.jolokia.server.core.request.BadRequestException;
import org.jolokia.server.core.request.notification.AddCommand;
import org.jolokia.server.core.request.notification.ListCommand;
import org.jolokia.server.core.request.notification.NotificationCommand;
import org.jolokia.server.core.request.notification.NotificationCommandType;
import org.jolokia.server.core.request.notification.OpenCommand;
import org.jolokia.server.core.request.notification.PingCommand;
import org.jolokia.server.core.request.notification.RegisterCommand;
import org.jolokia.server.core.request.notification.RemoveCommand;
import org.jolokia.server.core.request.notification.UnregisterCommand;

public final class NotificationCommandFactory {
    private static final Map<NotificationCommandType, Creator> CREATORS = new HashMap<NotificationCommandType, Creator>();

    private NotificationCommandFactory() {
    }

    public static NotificationCommand createCommand(Deque<String> pStack) throws BadRequestException {
        String command = pStack.pop();
        NotificationCommandType type = NotificationCommandType.getTypeByName(command);
        return CREATORS.get((Object)type).create(pStack, null);
    }

    public static NotificationCommand createCommand(Map<String, ?> pCommandMap) throws BadRequestException {
        String command = (String)pCommandMap.get("command");
        NotificationCommandType type = NotificationCommandType.getTypeByName(command);
        return CREATORS.get((Object)type).create(null, pCommandMap);
    }

    static {
        CREATORS.put(NotificationCommandType.REGISTER, (pStack, pMap) -> new RegisterCommand());
        CREATORS.put(NotificationCommandType.UNREGISTER, (pStack, pMap) -> pStack != null ? new UnregisterCommand(pStack) : new UnregisterCommand(pMap));
        CREATORS.put(NotificationCommandType.ADD, (pStack, pMap) -> pStack != null ? new AddCommand(pStack) : new AddCommand(pMap));
        CREATORS.put(NotificationCommandType.REMOVE, (pStack, pMap) -> pStack != null ? new RemoveCommand(pStack) : new RemoveCommand(pMap));
        CREATORS.put(NotificationCommandType.PING, (pStack, pMap) -> pStack != null ? new PingCommand(pStack) : new PingCommand(pMap));
        CREATORS.put(NotificationCommandType.OPEN, (pStack, pMap) -> pStack != null ? new OpenCommand(pStack) : new OpenCommand(pMap));
        CREATORS.put(NotificationCommandType.LIST, (pStack, pMap) -> pStack != null ? new ListCommand(pStack) : new ListCommand(pMap));
    }

    private static interface Creator {
        public NotificationCommand create(Deque<String> var1, Map<String, ?> var2) throws BadRequestException;
    }
}

