/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.request;

import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.jolokia.core.util.EscapeUtil;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.request.BadRequestException;
import org.jolokia.server.core.request.JolokiaObjectNameRequest;
import org.jolokia.server.core.request.ProcessingParameters;
import org.jolokia.server.core.request.RequestCreator;
import org.jolokia.server.core.util.RequestType;

public class JolokiaWriteRequest
extends JolokiaObjectNameRequest {
    private final Object value;
    private final String attributeName;

    JolokiaWriteRequest(String pObjectName, String pAttribute, Object pValue, List<String> pPathParts, ProcessingParameters pInitParams) throws BadRequestException {
        super(RequestType.WRITE, pObjectName, pPathParts, pInitParams, true);
        this.attributeName = pAttribute;
        this.value = pValue;
    }

    JolokiaWriteRequest(Map<String, ?> pRequestMap, ProcessingParameters pParams) throws BadRequestException {
        super(pRequestMap, pParams, true);
        this.value = pRequestMap.get("value");
        this.attributeName = (String)pRequestMap.get("attribute");
    }

    public Object getValue() {
        return this.value;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public boolean useReturnValueWithPath() {
        return false;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder("JolokiaWriteRequest[");
        ret.append("attribute=").append(this.getAttributeName()).append(", value=").append(this.getValue());
        String baseInfo = this.getInfo();
        if (baseInfo != null) {
            ret.append(", ").append(baseInfo);
        }
        ret.append("]");
        return ret.toString();
    }

    @Override
    public JSONObject toJSON() {
        JSONObject ret = super.toJSON();
        if (this.attributeName != null) {
            ret.put("attribute", this.attributeName);
        }
        if (this.value != null) {
            ret.put("value", this.value);
        }
        return ret;
    }

    static RequestCreator<JolokiaWriteRequest> newCreator() {
        return new RequestCreator<JolokiaWriteRequest>(){

            @Override
            public JolokiaWriteRequest create(Deque<String> pStack, ProcessingParameters pParams) throws BadRequestException {
                if (pStack == null || pStack.size() < 3) {
                    throw new BadRequestException("Write GET requests require at least three path elements");
                }
                return new JolokiaWriteRequest(pStack.pop(), pStack.pop(), EscapeUtil.convertSpecialStringTags(pStack.pop()), this.prepareExtraArgs(pStack), pParams);
            }

            @Override
            public JolokiaWriteRequest create(JSONObject requestMap, ProcessingParameters pParams) throws BadRequestException {
                if (requestMap == null) {
                    throw new BadRequestException("Can't create Write POST request");
                }
                if (!requestMap.containsKey("mbean")) {
                    throw new BadRequestException("Write POST requests require an ObjectName to write to");
                }
                if (!requestMap.containsKey("attribute")) {
                    throw new BadRequestException("Write POST requests require an attribute name to write to");
                }
                if (!requestMap.containsKey("value")) {
                    throw new BadRequestException("Write POST requests require a value to set (may be a null)");
                }
                return new JolokiaWriteRequest(requestMap, pParams);
            }
        };
    }
}

