/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.jolokia.core.util.EscapeUtil;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.request.BadRequestException;
import org.jolokia.server.core.request.JolokiaObjectNameRequest;
import org.jolokia.server.core.request.ProcessingParameters;
import org.jolokia.server.core.request.RequestCreator;
import org.jolokia.server.core.util.RequestType;

public class JolokiaReadRequest
extends JolokiaObjectNameRequest {
    private String attributeName = null;
    private List<String> attributeNames;
    private boolean multiAttributeMode = false;

    JolokiaReadRequest(String pObjectName, String pAttribute, List<String> pPathParts, ProcessingParameters pInitParams) throws BadRequestException {
        super(RequestType.READ, pObjectName, pPathParts, pInitParams, true);
        this.detectAttributesToRead(pAttribute);
    }

    JolokiaReadRequest(Map<String, ?> pRequestMap, ProcessingParameters pParams) throws BadRequestException {
        super(pRequestMap, pParams, true);
        this.detectAttributesToRead(pRequestMap.get("attribute"));
    }

    public String getAttributeName() {
        if (this.multiAttributeMode) {
            throw new IllegalStateException("READ Request is for " + String.valueOf(this.attributeNames.isEmpty() ? "all" : Integer.valueOf(this.attributeNames.size())) + " attributes, use getAttributeNames() instead.");
        }
        return this.attributeName;
    }

    public List<String> getAttributeNames() {
        if (!this.multiAttributeMode) {
            throw new IllegalStateException("READ Request is for single \"" + this.attributeName + "\" attribute, use getAttributeName() instead.");
        }
        return this.attributeNames;
    }

    public boolean isMultiAttributeMode() {
        return this.multiAttributeMode;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject ret = super.toJSON();
        ret.put("attribute", this.multiAttributeMode ? new JSONArray((Collection<?>)this.attributeNames) : this.attributeName);
        return ret;
    }

    static RequestCreator<JolokiaReadRequest> newCreator() {
        return new RequestCreator<JolokiaReadRequest>(){

            @Override
            public JolokiaReadRequest create(Deque<String> pStack, ProcessingParameters pParams) throws BadRequestException {
                if (pStack == null || pStack.isEmpty()) {
                    throw new BadRequestException("Read GET requests require at least 1 path element for ObjectName to read from");
                }
                return new JolokiaReadRequest(pStack.pop(), this.popOrNull(pStack), this.prepareExtraArgs(pStack), pParams);
            }

            @Override
            public JolokiaReadRequest create(JSONObject requestMap, ProcessingParameters pParams) throws BadRequestException {
                if (requestMap == null || !requestMap.containsKey("mbean")) {
                    throw new BadRequestException("Read POST requests require an ObjectName to read from (may be a pattern)");
                }
                return new JolokiaReadRequest(requestMap, pParams);
            }
        };
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("JolokiaReadRequest[");
        this.appendReadParameters(ret);
        String baseInfo = this.getInfo();
        if (baseInfo != null) {
            ret.append(", ").append(baseInfo);
        }
        ret.append("]");
        return ret.toString();
    }

    private void appendReadParameters(StringBuffer pRet) {
        if (this.multiAttributeMode) {
            pRet.append("attribute=[");
            for (int i = 0; i < this.attributeNames.size(); ++i) {
                pRet.append(this.attributeNames.get(i));
                if (i >= this.attributeNames.size() - 1) continue;
                pRet.append(",");
            }
            pRet.append("]");
        } else {
            pRet.append("attribute=").append(this.getAttributeName());
        }
    }

    private void detectAttributesToRead(Object config) throws BadRequestException {
        List<String> names;
        if (config instanceof String) {
            names = EscapeUtil.split((String)config, "\\\\", ",");
            this.multiAttributeMode = names == null || names.size() != 1;
        } else if (config instanceof Collection) {
            Collection col = (Collection)config;
            names = new ArrayList<String>();
            for (Object v : col) {
                String name;
                if (!(v instanceof String) || (name = (String)v).trim().isEmpty()) continue;
                names.add(name);
            }
            this.multiAttributeMode = true;
        } else if (config == null) {
            names = new ArrayList<String>();
            this.multiAttributeMode = true;
        } else {
            throw new BadRequestException("Can't determine attribute names to read from " + String.valueOf(this.getObjectName()) + " from " + String.valueOf(config.getClass()) + " parameter");
        }
        if (!this.multiAttributeMode) {
            this.attributeName = names.get(0);
            if (this.attributeName == null || this.attributeName.trim().isEmpty()) {
                this.multiAttributeMode = true;
                this.attributeName = null;
            }
        }
        if (this.multiAttributeMode) {
            this.attributeNames = names == null ? new ArrayList<String>() : new ArrayList<String>(names);
        }
    }
}

