/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.request;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.jolokia.core.util.EscapeUtil;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.request.BadRequestException;
import org.jolokia.server.core.request.JolokiaObjectNameRequest;
import org.jolokia.server.core.request.ProcessingParameters;
import org.jolokia.server.core.request.RequestCreator;
import org.jolokia.server.core.util.RequestType;

public class JolokiaExecRequest
extends JolokiaObjectNameRequest {
    private final String operation;
    private List<?> arguments;
    private boolean pathCreated;

    JolokiaExecRequest(String pObjectName, String pOperation, List<?> pArguments, ProcessingParameters pParams) throws BadRequestException {
        super(RequestType.EXEC, pObjectName, null, pParams, true);
        this.operation = pOperation;
        this.arguments = pArguments;
    }

    JolokiaExecRequest(Map<String, ?> pRequestMap, ProcessingParameters pParams) throws BadRequestException {
        super(pRequestMap, pParams, true);
        this.operation = (String)pRequestMap.get("operation");
        this.arguments = (List)pRequestMap.get("arguments");
    }

    public JolokiaExecRequest withChangedObjectName(ObjectName name) {
        try {
            return new JolokiaExecRequest(name.getCanonicalName(), this.operation, this.arguments, this.processingConfig);
        }
        catch (BadRequestException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public String getOperation() {
        return this.operation;
    }

    public List<?> getArguments() {
        return this.arguments;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject ret = super.toJSON();
        if (this.arguments != null && !this.arguments.isEmpty()) {
            ret.put("arguments", this.arguments);
        }
        ret.put("operation", this.operation);
        return ret;
    }

    public void splitArgumentsAndPath(int nrParams, List<String> pathParts) {
        if (this.pathCreated) {
            return;
        }
        this.arguments = this.arguments.subList(0, nrParams);
        this.setPathParts(pathParts);
        this.pathCreated = true;
    }

    static RequestCreator<JolokiaExecRequest> newCreator() {
        return new RequestCreator<JolokiaExecRequest>(){

            @Override
            public JolokiaExecRequest create(Deque<String> pStack, ProcessingParameters pParams) throws BadRequestException {
                if (pStack == null || pStack.size() < 2) {
                    throw new BadRequestException("Exec GET requests require at least two path elements");
                }
                return new JolokiaExecRequest(pStack.pop(), pStack.pop(), JolokiaExecRequest.convertSpecialStringTags(this.prepareExtraArgs(pStack)), pParams);
            }

            @Override
            public JolokiaExecRequest create(JSONObject requestMap, ProcessingParameters pParams) throws BadRequestException {
                if (requestMap == null) {
                    throw new BadRequestException("Can't create Exec POST request");
                }
                if (!requestMap.containsKey("mbean")) {
                    throw new BadRequestException("Exec POST requests require an ObjectName to invoke");
                }
                if (!requestMap.containsKey("operation")) {
                    throw new BadRequestException("Exec POST requests require an operation name to invoke");
                }
                return new JolokiaExecRequest(requestMap, pParams);
            }
        };
    }

    private static List<String> convertSpecialStringTags(List<String> extraArgs) {
        if (extraArgs == null) {
            return null;
        }
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : extraArgs) {
            args.add(EscapeUtil.convertSpecialStringTags(arg));
        }
        return args;
    }

    public String toString() {
        String baseInfo;
        StringBuilder ret = new StringBuilder("JolokiaExecRequest[");
        ret.append("operation=").append(this.getOperation());
        if (this.arguments != null && !this.arguments.isEmpty()) {
            ret.append(", arguments=").append(this.getArguments());
        }
        if ((baseInfo = this.getInfo()) != null) {
            ret.append(", ").append(baseInfo);
        }
        ret.append("]");
        return ret.toString();
    }
}

