/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.backend;

import java.io.IOException;
import java.util.SortedSet;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import org.jolokia.server.core.backend.RequestDispatcher;
import org.jolokia.server.core.request.BadRequestException;
import org.jolokia.server.core.request.EmptyResponseException;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.request.NotChangedException;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.request.RequestHandler;

class RequestDispatcherImpl
implements RequestDispatcher {
    private final JolokiaContext jolokiaContext;

    RequestDispatcherImpl(JolokiaContext pPJolokiaContext) {
        this.jolokiaContext = pPJolokiaContext;
    }

    @Override
    public Object dispatch(JolokiaRequest pJolokiaRequest) throws IOException, JMException, JMRuntimeException, NotChangedException, BadRequestException, EmptyResponseException {
        boolean found = false;
        Object result = null;
        SortedSet<RequestHandler> handlers = this.jolokiaContext.getServices(RequestHandler.class);
        for (RequestHandler requestHandler : handlers) {
            if (!requestHandler.canHandle(pJolokiaRequest)) continue;
            if (pJolokiaRequest.isExclusive()) {
                return requestHandler.handleRequest(pJolokiaRequest, null);
            }
            result = requestHandler.handleRequest(pJolokiaRequest, result);
            found = true;
        }
        if (!found) {
            throw new IllegalStateException("Internal error: No request handler found for handling " + String.valueOf(pJolokiaRequest));
        }
        return result;
    }
}

