/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.backend;

import java.io.IOException;
import java.util.List;
import java.util.SortedSet;
import javax.management.AttributeNotFoundException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import org.jolokia.core.service.serializer.SerializeOptions;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.backend.RequestDispatcher;
import org.jolokia.server.core.backend.RequestDispatcherImpl;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.request.BadRequestException;
import org.jolokia.server.core.request.EmptyResponseException;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.request.NotChangedException;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.request.RequestInterceptor;
import org.jolokia.server.core.service.serializer.Serializer;

public class BackendManager {
    private final JolokiaContext jolokiaCtx;
    private final RequestDispatcher requestDispatcher;
    private final SerializeOptions.Builder convertOptionsBuilder;
    private final boolean includeRequestGlobal;

    public BackendManager(JolokiaContext pJolokiaCtx) {
        this(pJolokiaCtx, new RequestDispatcherImpl(pJolokiaCtx));
    }

    BackendManager(JolokiaContext pJolokiaCtx, RequestDispatcher pRequestDispatcher) {
        this.jolokiaCtx = pJolokiaCtx;
        this.requestDispatcher = pRequestDispatcher;
        if (pJolokiaCtx != null) {
            this.convertOptionsBuilder = new SerializeOptions.Builder(this.getOrDefault(pJolokiaCtx.getConfig(ConfigKey.MAX_DEPTH), 0), this.getOrDefault(pJolokiaCtx.getConfig(ConfigKey.MAX_COLLECTION_SIZE), 0), this.getOrDefault(pJolokiaCtx.getConfig(ConfigKey.MAX_OBJECTS), 0));
            this.includeRequestGlobal = this.getOrDefault(pJolokiaCtx.getConfig(ConfigKey.INCLUDE_REQUEST), true);
        } else {
            this.convertOptionsBuilder = new SerializeOptions.Builder();
            this.includeRequestGlobal = true;
        }
    }

    private int getOrDefault(String pValue, int defaultValue) {
        return pValue != null ? Integer.parseInt(pValue) : defaultValue;
    }

    private boolean getOrDefault(String pValue, boolean defaultValue) {
        return pValue != null ? Boolean.parseBoolean(pValue) : defaultValue;
    }

    public JSONObject handleRequest(JolokiaRequest pJmxReq) throws IOException, JMException, JMRuntimeException, BadRequestException, EmptyResponseException {
        JSONObject json;
        boolean debug = this.jolokiaCtx.isDebug();
        long time = 0L;
        if (debug) {
            time = System.currentTimeMillis();
        }
        try {
            json = this.callRequestDispatcher(pJmxReq);
            json.put("status", 200);
        }
        catch (NotChangedException exp) {
            json = new JSONObject();
            json.put("status", 304);
        }
        this.addRequestToResponseIfNeeded(json, pJmxReq);
        this.intercept(pJmxReq, json);
        if (!json.containsKey("timestamp")) {
            json.put("timestamp", System.currentTimeMillis() / 1000L);
        }
        if (debug) {
            this.jolokiaCtx.debug("Execution time: " + (System.currentTimeMillis() - time) + " ms");
            this.jolokiaCtx.debug("Response: " + json.toJSONString());
        }
        return json;
    }

    private JSONObject callRequestDispatcher(JolokiaRequest pJmxReq) throws IOException, JMException, JMRuntimeException, NotChangedException, BadRequestException, EmptyResponseException {
        Object result = this.requestDispatcher.dispatch(pJmxReq);
        Serializer serializer = this.jolokiaCtx.getMandatoryService(Serializer.class);
        List<String> pathParts = pJmxReq.useReturnValueWithPath() ? pJmxReq.getPathParts() : null;
        SerializeOptions options = this.getSerializeOptions(pJmxReq);
        Object jsonResult = serializer.serialize(result, pathParts, options);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", jsonResult);
        return jsonObject;
    }

    private void intercept(JolokiaRequest pJmxReq, JSONObject pRetValue) {
        SortedSet<RequestInterceptor> interceptors = this.jolokiaCtx.getServices(RequestInterceptor.class);
        for (RequestInterceptor interceptor : interceptors) {
            try {
                interceptor.intercept(pJmxReq, pRetValue);
            }
            catch (RuntimeException exp) {
                this.jolokiaCtx.error("Cannot call request interceptor " + String.valueOf(interceptor) + ": " + exp.getMessage(), exp);
            }
        }
    }

    public Object convertExceptionToJson(Throwable pExp, JolokiaRequest pJmxReq) {
        SerializeOptions options = this.getSerializeOptions(pJmxReq);
        try {
            Serializer serializer = this.jolokiaCtx.getMandatoryService(Serializer.class);
            return serializer.serialize(pExp, null, options);
        }
        catch (AttributeNotFoundException e) {
            return null;
        }
    }

    public void addRequestToResponseIfNeeded(JSONObject json, JolokiaRequest pJmxReq) {
        if (pJmxReq == null) {
            return;
        }
        String includeRequestLocal = pJmxReq.getParameter(ConfigKey.INCLUDE_REQUEST);
        if (this.includeRequestGlobal && !"false".equals(includeRequestLocal) || !this.includeRequestGlobal && "true".equals(includeRequestLocal)) {
            json.put("request", pJmxReq.toJSON());
        }
    }

    private SerializeOptions getSerializeOptions(JolokiaRequest pJmxReq) {
        return this.convertOptionsBuilder.maxDepth(pJmxReq.getParameterAsInt(ConfigKey.MAX_DEPTH)).maxCollectionSize(pJmxReq.getParameterAsInt(ConfigKey.MAX_COLLECTION_SIZE)).maxObjects(pJmxReq.getParameterAsInt(ConfigKey.MAX_OBJECTS)).serializeLong(pJmxReq.getParameter(ConfigKey.SERIALIZE_LONG)).faultHandler(pJmxReq.getValueFaultHandler()).useAttributeFilter(pJmxReq.getPathParts() != null).build();
    }
}

