/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.security;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.jolokia.asn1.DERBitString;
import org.jolokia.asn1.DERBoolean;
import org.jolokia.asn1.DERDirect;
import org.jolokia.asn1.DERInteger;
import org.jolokia.asn1.DERNull;
import org.jolokia.asn1.DERObject;
import org.jolokia.asn1.DERObjectIdentifier;
import org.jolokia.asn1.DEROctetString;
import org.jolokia.asn1.DERSequence;
import org.jolokia.asn1.DERSet;
import org.jolokia.asn1.DERTaggedObject;
import org.jolokia.asn1.DERUtcTime;
import org.jolokia.core.util.CryptoUtil;
import org.jolokia.jvmagent.JolokiaServerConfig;
import org.jolokia.server.core.Version;
import org.jolokia.server.core.util.NetworkUtil;

public class KeyStoreUtil {
    private KeyStoreUtil() {
    }

    public static void updateWithCaCertificates(KeyStore pTrustStore, File pCaCerts) throws IOException, CertificateException, KeyStoreException {
        try (FileInputStream is = new FileInputStream(pCaCerts);){
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            Collection<? extends Certificate> certificates = certFactory.generateCertificates(is);
            for (Certificate certificate : certificates) {
                X509Certificate cert = (X509Certificate)certificate;
                Object alias = cert.getSubjectX500Principal().getName();
                String sid = cert.getSerialNumber().toString();
                if (sid != null) {
                    alias = (String)alias + "|" + sid;
                }
                pTrustStore.setCertificateEntry((String)alias, cert);
            }
        }
    }

    public static void updateWithServerCertificate(KeyStore pKeyStore, File pServerCert, File pServerKey, String pKeyAlgo, char[] pPassword) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        try (FileInputStream is = new FileInputStream(pServerCert);){
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            Certificate[] certificates = certFactory.generateCertificates(is).toArray(new Certificate[1]);
            CryptoUtil.CryptoStructure cryptoData = CryptoUtil.decodePemIfNeeded(pServerKey);
            byte[] keyBytes = cryptoData.derData();
            KeySpec keySpec = CryptoUtil.decodePrivateKey(cryptoData, pPassword);
            PrivateKey privateKey = CryptoUtil.generatePrivateKey(keySpec, pKeyAlgo);
            X509Certificate x509Certificate = (X509Certificate)certificates[0];
            if (certificates.length == 1 && !CryptoUtil.keysMatch(privateKey, x509Certificate.getPublicKey())) {
                throw new IllegalArgumentException("Private key from " + String.valueOf(pServerKey) + " and public key from " + String.valueOf(pServerCert) + " do not match");
            }
            String alias = x509Certificate.getSubjectX500Principal().getName();
            pKeyStore.setKeyEntry(alias, privateKey, pPassword, certificates);
        }
    }

    public static void updateWithSelfSignedServerCertificate(KeyStore pKeyStore, JolokiaServerConfig pConfig) throws NoSuchAlgorithmException, KeyStoreException {
        String[] certAttributes = new String[]{"Jolokia Agent " + Version.getAgentVersion(), "JVM", "jolokia.org", "Pegnitz", "Franconia", "DE"};
        KeyPair keypair = KeyStoreUtil.createRSAKeyPair();
        PrivateKey privKey = keypair.getPrivate();
        Certificate[] chain = new X509Certificate[1];
        Date from = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(from);
        cal.add(1, 1);
        Date to = cal.getTime();
        chain[0] = KeyStoreUtil.generateSelfCertificate(keypair, certAttributes, from, to.getTime() - from.getTime(), pConfig);
        pKeyStore.setKeyEntry("jolokia-agent", privKey, new char[0], chain);
    }

    private static KeyPair createRSAKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(4096);
        return kpg.generateKeyPair();
    }

    private static X509Certificate generateSelfCertificate(KeyPair keypair, String[] attributes, Date fromDate, long valid, JolokiaServerConfig pConfig) throws NoSuchAlgorithmException {
        DERTaggedObject version = new DERTaggedObject(DERTaggedObject.TagClass.ContextSpecific, false, 0, new DERInteger(2));
        DERInteger serialNumber = new DERInteger(BigInteger.valueOf(new Date().getTime()));
        DERSequence signature = new DERSequence(new DERObject[]{new DERObjectIdentifier("1.2.840.113549.1.1.13"), new DERNull()});
        DERSequence issuerAndSubject = new DERSequence(new DERObject[]{new DERSet(new DERObject[]{new DERSequence(new DERObject[]{new DERObjectIdentifier("2.5.4.6"), new DEROctetString(19, attributes[5])})}), new DERSet(new DERObject[]{new DERSequence(new DERObject[]{new DERObjectIdentifier("2.5.4.8"), new DEROctetString(12, attributes[4])})}), new DERSet(new DERObject[]{new DERSequence(new DERObject[]{new DERObjectIdentifier("2.5.4.7"), new DEROctetString(12, attributes[3])})}), new DERSet(new DERObject[]{new DERSequence(new DERObject[]{new DERObjectIdentifier("2.5.4.10"), new DEROctetString(12, attributes[2])})}), new DERSet(new DERObject[]{new DERSequence(new DERObject[]{new DERObjectIdentifier("2.5.4.11"), new DEROctetString(12, attributes[1])})}), new DERSet(new DERObject[]{new DERSequence(new DERObject[]{new DERObjectIdentifier("2.5.4.3"), new DEROctetString(12, attributes[0])})})});
        DERSequence validity = new DERSequence(new DERObject[]{new DERUtcTime(fromDate), new DERUtcTime(new Date(fromDate.getTime() + valid))});
        DERDirect subjectPublicKeyInfo = new DERDirect(keypair.getPublic().getEncoded());
        MessageDigest publicKeyDigest = MessageDigest.getInstance("SHA1");
        byte[] caPublicKeySHA1 = publicKeyDigest.digest(keypair.getPublic().getEncoded());
        ArrayList<DERTaggedObject> altNames = new ArrayList<DERTaggedObject>();
        altNames.add(new DERTaggedObject(DERTaggedObject.TagClass.ContextSpecific, true, 7, new DERDirect(new byte[]{127, 0, 0, 1})));
        altNames.add(new DERTaggedObject(DERTaggedObject.TagClass.ContextSpecific, true, 7, new DERDirect(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1})));
        altNames.add(new DERTaggedObject(DERTaggedObject.TagClass.ContextSpecific, true, 2, new DERDirect("localhost".getBytes(StandardCharsets.UTF_8))));
        Map networkConfig = pConfig == null ? Collections.emptyMap() : pConfig.getJolokiaConfig().getNetworkConfig();
        NetworkUtil.getBestMatchAddresses().forEach((name, addresses) -> {
            addresses.getIa4().ifPresent(ip4 -> {
                if (!ip4.isLoopbackAddress()) {
                    altNames.add(new DERTaggedObject(DERTaggedObject.TagClass.ContextSpecific, true, 7, new DERDirect(ip4.getAddress())));
                    if (networkConfig.containsKey("host:" + name)) {
                        String host4 = (String)networkConfig.get("host:" + name);
                        String ip4address = (String)networkConfig.get("ip:" + name);
                        if (ip4address != null && !host4.isEmpty() && !host4.startsWith(ip4address)) {
                            altNames.add(new DERTaggedObject(DERTaggedObject.TagClass.ContextSpecific, true, 2, new DERDirect(host4.getBytes(StandardCharsets.UTF_8))));
                        }
                    }
                }
            });
            addresses.getIa6().ifPresent(ip6 -> {
                if (!ip6.isLoopbackAddress()) {
                    altNames.add(new DERTaggedObject(DERTaggedObject.TagClass.ContextSpecific, true, 7, new DERDirect(ip6.getAddress())));
                    if (networkConfig.containsKey("host6:" + name)) {
                        String host6 = (String)networkConfig.get("host6:" + name);
                        String ip6address = (String)networkConfig.get("ip6:" + name);
                        if (ip6address != null && !host6.isEmpty() && !host6.startsWith(ip6address)) {
                            altNames.add(new DERTaggedObject(DERTaggedObject.TagClass.ContextSpecific, true, 2, new DERDirect(host6.getBytes(StandardCharsets.UTF_8))));
                        }
                    }
                }
            });
        });
        DERSequence extensionsSeq = new DERSequence(new DERObject[]{new DERSequence(new DERObject[]{new DERObjectIdentifier("2.5.29.19"), new DEROctetString(4, new DERSequence(new DERObject[]{new DERBoolean(false)}).getEncoded())}), new DERSequence(new DERObject[]{new DERObjectIdentifier("2.5.29.15"), new DEROctetString(4, new DERBitString(new byte[]{-2}).getEncoded())}), new DERSequence(new DERObject[]{new DERObjectIdentifier("2.5.29.35"), new DEROctetString(4, new DERSequence(new DERObject[]{new DERTaggedObject(DERTaggedObject.TagClass.ContextSpecific, true, 0, new DERDirect(caPublicKeySHA1))}).getEncoded())}), new DERSequence(new DERObject[]{new DERObjectIdentifier("2.5.29.14"), new DEROctetString(4, new DEROctetString(4, caPublicKeySHA1).getEncoded())}), new DERSequence(new DERObject[]{new DERObjectIdentifier("2.5.29.37"), new DEROctetString(4, new DERSequence(new DERObject[]{new DERObjectIdentifier("1.3.6.1.5.5.7.3.1")}).getEncoded())}), new DERSequence(new DERObject[]{new DERObjectIdentifier("2.5.29.17"), new DEROctetString(4, new DERSequence(altNames.toArray(new DERObject[0])).getEncoded())})});
        DERTaggedObject extensions = new DERTaggedObject(DERTaggedObject.TagClass.ContextSpecific, false, 3, extensionsSeq);
        DERSequence tbsCertificate = new DERSequence(new DERObject[]{version, serialNumber, signature, issuerAndSubject, validity, issuerAndSubject, subjectPublicKeyInfo, extensions});
        try {
            Signature sig = Signature.getInstance("SHA512withRSA");
            sig.initSign(keypair.getPrivate(), SecureRandom.getInstance("SHA1PRNG"));
            sig.update(tbsCertificate.getEncoded());
            byte[] signatureBytes = sig.sign();
            DERSequence certificate = new DERSequence(new DERObject[]{tbsCertificate, new DERSequence(new DERObject[]{new DERObjectIdentifier("1.2.840.113549.1.1.13"), new DERNull()}), new DERBitString(signatureBytes)});
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certificate.getEncoded()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertificateException e) {
            throw new IllegalStateException("The getSelfCertificate-method threw an error.", e);
        }
    }
}

