/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.handler;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpsExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedActionException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.jolokia.json.JSONStructure;
import org.jolokia.jvmagent.ParsedUri;
import org.jolokia.jvmagent.handler.HttpExchangeBackChannel;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.http.BackChannelHolder;
import org.jolokia.server.core.http.HttpRequestHandler;
import org.jolokia.server.core.request.BadRequestException;
import org.jolokia.server.core.request.EmptyResponseException;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.util.IoUtil;
import org.jolokia.server.core.util.MimeTypeUtil;

public class JolokiaHttpHandler
implements HttpHandler {
    private final HttpRequestHandler requestHandler;
    private final String contextPath;
    private final Pattern contentTypePattern = Pattern.compile(".*;\\s*charset=([^;,]+)\\s*.*");
    private final JolokiaContext jolokiaContext;
    private final boolean allowDnsReverseLookup;
    private final Executor backChannelThreadPool = Executors.newCachedThreadPool();
    private final SimpleDateFormat rfc1123Format;

    public JolokiaHttpHandler(JolokiaContext pJolokiaContext) {
        this.jolokiaContext = pJolokiaContext;
        this.contextPath = this.jolokiaContext.getConfig(ConfigKey.AGENT_CONTEXT);
        this.requestHandler = new HttpRequestHandler(this.jolokiaContext);
        this.allowDnsReverseLookup = Boolean.parseBoolean(this.jolokiaContext.getConfig(ConfigKey.ALLOW_DNS_REVERSE_LOOKUP));
        this.rfc1123Format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    }

    @Override
    public void handle(HttpExchange pHttpExchange) throws IOException {
        try {
            this.checkAuthentication(pHttpExchange);
            Subject subject = (Subject)pHttpExchange.getAttribute("org.jolokia.jaasSubject");
            if (subject != null) {
                this.doHandleAs(subject, pHttpExchange);
            } else {
                this.doHandle(pHttpExchange);
            }
        }
        catch (SecurityException exp) {
            this.sendForbidden(pHttpExchange, exp);
        }
    }

    protected void checkAuthentication(HttpExchange pHttpExchange) throws SecurityException {
    }

    private void doHandleAs(Subject subject, HttpExchange pHttpExchange) throws IOException {
        try {
            Subject.doAs(subject, () -> {
                this.doHandle(pHttpExchange);
                return null;
            });
        }
        catch (SecurityException | PrivilegedActionException e) {
            this.sendInternalServerError(pHttpExchange, new Exception(e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandle(HttpExchange pExchange) throws IOException {
        ParsedUri parsedUri;
        JSONStructure json;
        block15: {
            json = null;
            URI uri = pExchange.getRequestURI();
            parsedUri = new ParsedUri(uri, this.contextPath);
            try {
                this.prepareBackChannel(pExchange);
                String scheme = pExchange instanceof HttpsExchange ? "https" : "http";
                InetSocketAddress address = pExchange.getRemoteAddress();
                String remoteHost = this.allowDnsReverseLookup ? address.getHostName() : null;
                this.requestHandler.checkAccess(scheme, remoteHost, address.getAddress().getHostAddress(), this.extractOriginOrReferer(pExchange));
                this.validateCallbackIfGiven(parsedUri);
                String method = pExchange.getRequestMethod();
                if ("GET".equalsIgnoreCase(method)) {
                    this.setHeaders(pExchange);
                    json = this.executeGetRequest(parsedUri);
                    break block15;
                }
                if ("POST".equalsIgnoreCase(method)) {
                    this.setHeaders(pExchange);
                    json = this.executePostRequest(parsedUri, pExchange);
                    break block15;
                }
                if ("OPTIONS".equalsIgnoreCase(method)) {
                    this.performCorsPreflightCheck(pExchange);
                    break block15;
                }
                throw new BadRequestException("HTTP Method " + method + " is not supported.");
            }
            catch (BadRequestException exp) {
                Object response = "400 (Bad Request)\n";
                if (exp.getMessage() != null) {
                    response = (String)response + "\n" + exp.getMessage() + "\n";
                }
                pExchange.getResponseHeaders().add("Content-Type", "text/plain; charset=utf-8");
                pExchange.sendResponseHeaders(400, ((String)response).length());
                OutputStream os = pExchange.getResponseBody();
                os.write(((String)response).getBytes());
                os.close();
                return;
            }
            catch (EmptyResponseException exp) {
                return;
            }
            catch (Throwable exp) {
                json = this.requestHandler.handleThrowable(exp);
            }
            finally {
                this.releaseBackChannel();
            }
        }
        if (json == null) {
            this.sendInternalServerError(pExchange, new Exception("Internal Server Error (no JSON response)"));
        } else {
            this.sendResponse(pExchange, parsedUri, json);
        }
    }

    private void prepareBackChannel(HttpExchange pExchange) {
        BackChannelHolder.set(new HttpExchangeBackChannel(pExchange, this.backChannelThreadPool));
    }

    private void releaseBackChannel() {
        BackChannelHolder.remove();
    }

    private void validateCallbackIfGiven(ParsedUri pUri) {
        String callback = pUri.getParameter(ConfigKey.CALLBACK.getKeyValue());
        if (callback != null && !MimeTypeUtil.isValidCallback(callback)) {
            throw new IllegalArgumentException("Invalid callback name given, which must be a valid javascript function name");
        }
    }

    private String extractOriginOrReferer(HttpExchange pExchange) {
        Headers headers = pExchange.getRequestHeaders();
        String origin = headers.getFirst("Origin");
        if (origin == null) {
            origin = headers.getFirst("Referer");
        }
        return origin != null ? origin.replaceAll("[\\n\\r]*", "") : null;
    }

    private JSONStructure executeGetRequest(ParsedUri parsedUri) throws EmptyResponseException, BadRequestException {
        return this.requestHandler.handleGetRequest(parsedUri.getUri().toString(), parsedUri.getPathInfo(), parsedUri.getParameterMap());
    }

    private JSONStructure executePostRequest(ParsedUri pUri, HttpExchange pExchange) throws IOException, EmptyResponseException, BadRequestException {
        Matcher matcher;
        String encoding = null;
        Headers headers = pExchange.getRequestHeaders();
        String cType = headers.getFirst("Content-Type");
        if (cType != null && (matcher = this.contentTypePattern.matcher(cType)).matches()) {
            encoding = matcher.group(1);
        }
        InputStream is = pExchange.getRequestBody();
        return this.requestHandler.handlePostRequest(pUri.toString(), is, encoding, pUri.getParameterMap());
    }

    private void performCorsPreflightCheck(HttpExchange pExchange) {
        Headers requestHeaders = pExchange.getRequestHeaders();
        Map<String, String> respHeaders = this.requestHandler.handleCorsPreflightRequest(this.extractOriginOrReferer(pExchange), requestHeaders.getFirst("Access-Control-Request-Headers"));
        Headers responseHeaders = pExchange.getResponseHeaders();
        for (Map.Entry<String, String> entry : respHeaders.entrySet()) {
            responseHeaders.set(entry.getKey(), entry.getValue());
        }
    }

    private void setHeaders(HttpExchange pExchange) {
        String origin = this.requestHandler.extractCorsOrigin(pExchange.getRequestHeaders().getFirst("Origin"));
        Headers headers = pExchange.getResponseHeaders();
        if (origin != null) {
            headers.set("Access-Control-Allow-Origin", origin);
            headers.set("Access-Control-Allow-Credentials", "true");
        }
        headers.set("Cache-Control", "no-cache");
        Calendar cal = Calendar.getInstance();
        headers.set("Date", this.formatHeaderDate(cal.getTime()));
        cal.add(10, -1);
        headers.set("Expires", this.formatHeaderDate(cal.getTime()));
    }

    private void sendForbidden(HttpExchange pExchange, SecurityException securityException) throws IOException {
        Object response = "403 (Forbidden)\n";
        if (securityException != null && securityException.getMessage() != null) {
            response = (String)response + "\n" + securityException.getMessage() + "\n";
        }
        pExchange.getResponseHeaders().add("Content-Type", "text/plain; charset=utf-8");
        pExchange.sendResponseHeaders(403, ((String)response).length());
        OutputStream os = pExchange.getResponseBody();
        os.write(((String)response).getBytes());
        os.close();
    }

    private void sendInternalServerError(HttpExchange pExchange, Exception exception) throws IOException {
        Object response = "500 (Internal Server Error)\n";
        if (exception != null && exception.getMessage() != null) {
            response = (String)response + "\n" + exception.getMessage() + "\n";
        }
        pExchange.getResponseHeaders().add("Content-Type", "text/plain; charset=utf-8");
        pExchange.sendResponseHeaders(500, ((String)response).length());
        OutputStream os = pExchange.getResponseBody();
        os.write(((String)response).getBytes());
        os.close();
    }

    private void sendResponse(HttpExchange pExchange, ParsedUri pParsedUri, JSONStructure pJson) throws IOException {
        Headers headers = pExchange.getResponseHeaders();
        if (pJson != null) {
            headers.set("Content-Type", this.getMimeType(pParsedUri) + "; charset=utf-8");
            pExchange.sendResponseHeaders(200, 0L);
            OutputStreamWriter writer = new OutputStreamWriter(pExchange.getResponseBody(), StandardCharsets.UTF_8);
            String callback = pParsedUri.getParameter(ConfigKey.CALLBACK.getKeyValue());
            IoUtil.streamResponseAndClose(writer, pJson, callback != null && MimeTypeUtil.isValidCallback(callback) ? callback : null);
        } else {
            headers.set("Content-Type", "text/plain");
            pExchange.sendResponseHeaders(200, -1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllJSON(HttpExchange pExchange, ParsedUri pParsedUri, JSONStructure pJson) throws IOException {
        try (OutputStream out = null;){
            Headers headers = pExchange.getResponseHeaders();
            if (pJson != null) {
                headers.set("Content-Type", this.getMimeType(pParsedUri) + "; charset=utf-8");
                String json = pJson.toJSONString();
                String callback = pParsedUri.getParameter(ConfigKey.CALLBACK.getKeyValue());
                String content = callback != null && MimeTypeUtil.isValidCallback(callback) ? callback + "(" + json + ");" : json;
                byte[] response = content.getBytes(StandardCharsets.UTF_8);
                pExchange.sendResponseHeaders(200, response.length);
                out = pExchange.getResponseBody();
                out.write(response);
            } else {
                headers.set("Content-Type", "text/plain");
                pExchange.sendResponseHeaders(200, -1L);
            }
        }
    }

    private String getMimeType(ParsedUri pParsedUri) {
        return MimeTypeUtil.getResponseMimeType(pParsedUri.getParameter(ConfigKey.MIME_TYPE.getKeyValue()), this.jolokiaContext.getConfig(ConfigKey.MIME_TYPE), pParsedUri.getParameter(ConfigKey.CALLBACK.getKeyValue()));
    }

    private String formatHeaderDate(Date date) {
        this.rfc1123Format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return this.rfc1123Format.format(date);
    }
}

