/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import org.jolokia.core.util.EscapeUtil;
import org.jolokia.jvmagent.JolokiaServerConfig;
import org.jolokia.server.core.config.SystemPropertyMode;

public class JvmAgentConfig
extends JolokiaServerConfig {
    private boolean isStopMode;

    public JvmAgentConfig(String pArgs) {
        this(JvmAgentConfig.split(pArgs));
    }

    public JvmAgentConfig(Map<String, String> pConfig) {
        Map<String, String> defaultConfig = this.getDefaultConfig();
        if (pConfig.containsKey("config")) {
            defaultConfig.putAll(this.readConfig(pConfig.get("config")));
        }
        this.init(pConfig, defaultConfig, SystemPropertyMode.FALLBACK);
        this.initMode(pConfig);
    }

    public boolean isModeStop() {
        return this.isStopMode;
    }

    private void initMode(Map<String, String> agentConfig) {
        String mode = agentConfig.get("mode");
        if (mode != null && !mode.equals("start") && !mode.equals("stop")) {
            throw new IllegalArgumentException("Invalid running mode '" + mode + "'. Must be either 'start' or 'stop'");
        }
        this.isStopMode = "stop".equals(mode);
    }

    private static Map<String, String> split(String pAgentArgs) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (pAgentArgs != null && !pAgentArgs.isEmpty()) {
            for (String arg : EscapeUtil.splitAsArray(pAgentArgs, "\\\\", ",")) {
                String[] prop = arg.split("=", 2);
                if (prop.length != 2) {
                    throw new IllegalArgumentException("jolokia: Invalid option '" + arg + "'");
                }
                ret.put(prop[0], prop[1]);
            }
        }
        return ret;
    }

    private Map<String, String> readConfig(String pFilename) {
        File file = new File(pFilename);
        try {
            FileInputStream is = new FileInputStream(file);
            return this.readPropertiesFromInputStream(is, pFilename);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("jolokia: Can not find configuration file " + pFilename, e);
        }
    }
}

