/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.jolokia.jvmagent.JolokiaServerConfig;

final class JolokiaHttpsConfigurator
extends HttpsConfigurator {
    private final JolokiaServerConfig config;

    JolokiaHttpsConfigurator(SSLContext pSSLContext, JolokiaServerConfig pConfig) {
        super(pSSLContext);
        this.config = pConfig;
    }

    @Override
    public void configure(HttpsParameters params) {
        try {
            SSLContext context = SSLContext.getDefault();
            SSLEngine engine = context.createSSLEngine();
            SSLParameters defaultSSLParameters = context.getDefaultSSLParameters();
            params.setWantClientAuth(this.config.useSslClientAuthentication());
            defaultSSLParameters.setWantClientAuth(this.config.useSslClientAuthentication());
            params.setCipherSuites(this.config.getSSLCipherSuites());
            defaultSSLParameters.setCipherSuites(this.config.getSSLCipherSuites());
            params.setProtocols(this.config.getSSLProtocols());
            defaultSSLParameters.setProtocols(this.config.getSSLProtocols());
            params.setSSLParameters(defaultSSLParameters);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("jolokia: Exception while configuring SSL context: " + e.getMessage(), e);
        }
    }
}

