/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.core.util;

import java.io.InputStream;
import java.util.Properties;

public class PropertyUtil {
    public static String VERSION;

    private PropertyUtil() {
    }

    public static String asJolokiaSystemProperty(String property) {
        if (property == null) {
            return null;
        }
        return "jolokia." + property;
    }

    public static String asJolokiaEnvVariable(String property) {
        if (property == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        boolean notFirst = false;
        for (char c : property.toCharArray()) {
            if (Character.isUpperCase(c) && notFirst) {
                buf.append("_").append(c);
            } else {
                buf.append(Character.toUpperCase(c));
            }
            notFirst = true;
        }
        buf.insert(0, "JOLOKIA_");
        return buf.toString();
    }

    public static String fromJolokiaSystemProperty(String property) {
        if (property == null) {
            return null;
        }
        if (!property.startsWith("jolokia.")) {
            return null;
        }
        return property.substring("jolokia.".length());
    }

    public static String fromJolokiaEnvVariable(String property) {
        if (property == null) {
            return null;
        }
        if (!property.startsWith("JOLOKIA_")) {
            return null;
        }
        property = property.substring("JOLOKIA_".length());
        String[] parts = property.split("_");
        StringBuilder buf = new StringBuilder();
        buf.append(parts[0].toLowerCase());
        for (int i = 1; i < parts.length; ++i) {
            if (parts[i].isEmpty()) continue;
            buf.append(Character.toUpperCase(parts[i].charAt(0))).append(parts[i].substring(1).toLowerCase());
        }
        return buf.toString();
    }

    static {
        try (InputStream is = PropertyUtil.class.getResourceAsStream("/jolokia-core-version.properties");){
            Properties props = new Properties();
            props.load(is);
            VERSION = props.getProperty("version");
        }
        catch (Exception e) {
            VERSION = "<unknown>";
        }
    }
}

