/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.core.util;

import javax.management.JMException;
import javax.management.JMRuntimeException;
import org.jolokia.json.JSONObject;

public class ErrorUtil {
    private ErrorUtil() {
    }

    public static String getExceptionMessage(Throwable exception) {
        String message = exception.getLocalizedMessage();
        if (message != null && !message.trim().isEmpty()) {
            return message;
        }
        return exception.getClass().getName();
    }

    public static void addBasicErrorResponseInformation(JSONObject result, Throwable exception) {
        result.put(".error", true);
        result.put("error_type", exception.getClass().getName());
        result.put("error", ErrorUtil.getExceptionMessage(exception));
        while (exception != null) {
            if (exception instanceof JMException || exception instanceof JMRuntimeException) {
                result.put("error_type_jmx", exception.getClass().getName());
                break;
            }
            if (exception.getCause() == exception) break;
            exception = exception.getCause();
        }
    }
}

