/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.core.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.EdECPrivateKey;
import java.security.interfaces.EdECPublicKey;
import java.security.interfaces.XECPrivateKey;
import java.security.interfaces.XECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.NamedParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.PSSParameterSpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.jolokia.asn1.DERBitString;
import org.jolokia.asn1.DERContextSpecific;
import org.jolokia.asn1.DERInteger;
import org.jolokia.asn1.DERObject;
import org.jolokia.asn1.DERObjectIdentifier;
import org.jolokia.asn1.DEROctetString;
import org.jolokia.asn1.DERSequence;
import org.jolokia.asn1.DERUtils;

public class CryptoUtil {
    private CryptoUtil() {
    }

    public static KeySpec decodePublicKey(CryptoStructure cryptoStructure) {
        return CryptoUtil.decodePublicKey(cryptoStructure, true);
    }

    private static KeySpec decodePublicKey(CryptoStructure cryptoStructure, boolean firstCheck) {
        block15: {
            DERObject[] seq;
            block16: {
                DERObject dERObject;
                DERSequence alg;
                block18: {
                    block17: {
                        DERObject e2;
                        block14: {
                            DERObject dERObject2;
                            DERObject object = DERUtils.parse(cryptoStructure.derData());
                            if (!(object instanceof DERSequence)) {
                                throw new IllegalArgumentException("Expected a public key encoded as ASN.1 SEQUENCE");
                            }
                            DERSequence sequence = (DERSequence)object;
                            seq = sequence.getValues();
                            if (cryptoStructure.hint != StructureHint.DER) break block14;
                            if (!firstCheck) {
                                throw new IllegalStateException("[internal, please report] Can't do another identification of a DER structure");
                            }
                            if (seq.length == 2 && seq[0] instanceof DERSequence && seq[1] instanceof DERBitString) {
                                return CryptoUtil.decodePublicKey(cryptoStructure.withNewHint(StructureHint.X509_SUBJECT_PUBLIC_KEY_INFO), false);
                            }
                            if (seq.length == 2 && (dERObject2 = seq[0]) instanceof DERInteger) {
                                DERInteger n = (DERInteger)dERObject2;
                                dERObject2 = seq[1];
                                if (dERObject2 instanceof DERInteger) {
                                    DERInteger e2 = (DERInteger)dERObject2;
                                    return CryptoUtil.decodePublicKey(cryptoStructure.withNewHint(StructureHint.RSA_PUBLIC_KEY), false);
                                }
                            }
                            break block15;
                        }
                        if (cryptoStructure.hint != StructureHint.X509_SUBJECT_PUBLIC_KEY_INFO) break block16;
                        if (seq.length != 2 || !((e2 = seq[0]) instanceof DERSequence)) break block17;
                        alg = (DERSequence)e2;
                        if (seq[1] instanceof DERBitString) break block18;
                    }
                    throw new IllegalArgumentException("SubjectPublicKeyInfo requires 2-element ASN.1 Sequence: algorithm:AlgorithmIdentifier and subjectPublicKey:BITSTRING");
                }
                if (alg.getValues().length > 0 && (dERObject = alg.getValues()[0]) instanceof DERObjectIdentifier) {
                    DERObjectIdentifier oid = (DERObjectIdentifier)dERObject;
                    if (DERObjectIdentifier.SUPPORTED_X509_PUBLIC_KEYS.contains(oid.asOid())) {
                        return new X509EncodedKeySpec(cryptoStructure.derData());
                    }
                    throw new IllegalArgumentException("Unsupported SubjectPublicKeyInfo.algorithm: " + oid.asOid());
                }
                throw new IllegalArgumentException("SubjectPublicKeyInfo not found in the ASN.1 structure");
            }
            if (cryptoStructure.hint == StructureHint.RSA_PUBLIC_KEY) {
                if (seq.length != 2 || !(seq[0] instanceof DERInteger) || !(seq[1] instanceof DERInteger)) {
                    throw new IllegalArgumentException("RSAPublicKey requires 2-element ASN.1 Sequence: modulus:INTEGER and publicExponent:INTEGER");
                }
                DERObject modulus = seq[0];
                DERObject publicExponent = seq[1];
                return new RSAPublicKeySpec(((DERInteger)modulus).asBigInteger(), ((DERInteger)publicExponent).asBigInteger());
            }
        }
        if (cryptoStructure.hint == StructureHint.DER || !firstCheck) {
            throw new IllegalArgumentException("Can't read public key from DER structure");
        }
        throw new IllegalArgumentException("Can't handle public keys in \"" + cryptoStructure.pemMarker + "\" format");
    }

    public static KeySpec decodePrivateKey(CryptoStructure cryptoStructure, char[] password) {
        return CryptoUtil.decodePrivateKey(cryptoStructure, password, true);
    }

    private static KeySpec decodePrivateKey(CryptoStructure cryptoStructure, char[] password, boolean firstCheck) {
        block65: {
            String algName;
            block76: {
                DERObjectIdentifier pbes1Oid;
                block78: {
                    block77: {
                        DERObject[] seq2;
                        DERSequence alg;
                        block71: {
                            DERObject dERObject;
                            DERObject dERObject2;
                            DERObjectIdentifier kdfOid;
                            DERObject dERObject3;
                            DERSequence encScheme;
                            block75: {
                                block74: {
                                    DERSequence kdf;
                                    DERObject primeExponentQ22;
                                    block73: {
                                        block72: {
                                            DERObject pub22;
                                            DERObject e22;
                                            DERObject cs22;
                                            block70: {
                                                block69: {
                                                    DERObject[] seq;
                                                    block66: {
                                                        DERInteger version;
                                                        DERObject p22;
                                                        block68: {
                                                            block67: {
                                                                block64: {
                                                                    DERObject object = DERUtils.parse(cryptoStructure.derData());
                                                                    if (!(object instanceof DERSequence)) {
                                                                        throw new IllegalArgumentException("Expected a private key encoded as ASN.1 SEQUENCE");
                                                                    }
                                                                    DERSequence sequence = (DERSequence)object;
                                                                    seq = sequence.getValues();
                                                                    if (cryptoStructure.hint != StructureHint.DER) break block64;
                                                                    if (!firstCheck) {
                                                                        throw new IllegalStateException("[internal, please report] Can't do another identification of a DER structure");
                                                                    }
                                                                    if (seq.length >= 3 && seq[0] instanceof DERInteger && seq[1] instanceof DERSequence && seq[2] instanceof DEROctetString) {
                                                                        return CryptoUtil.decodePrivateKey(cryptoStructure.withNewHint(StructureHint.PKCS8_PRIVATE_KEY), password, false);
                                                                    }
                                                                    if (seq.length >= 9 && Arrays.stream(seq).limit(9L).allMatch(el -> el instanceof DERInteger)) {
                                                                        return CryptoUtil.decodePrivateKey(cryptoStructure.withNewHint(StructureHint.RSA_PRIVATE_KEY), password, false);
                                                                    }
                                                                    if (seq.length >= 6 && Arrays.stream(seq).limit(9L).allMatch(el -> el instanceof DERInteger)) {
                                                                        return CryptoUtil.decodePrivateKey(cryptoStructure.withNewHint(StructureHint.DSA_PRIVATE_KEY), password, false);
                                                                    }
                                                                    if (seq.length == 2 && seq[0] instanceof DERSequence && seq[1] instanceof DEROctetString) {
                                                                        return CryptoUtil.decodePrivateKey(cryptoStructure.withNewHint(StructureHint.PKCS8_ENCRYPTED_PRIVATE_KEY), password, false);
                                                                    }
                                                                    if (seq.length >= 3 && seq[0] instanceof DERInteger && seq[1] instanceof DEROctetString && seq[2] instanceof DERContextSpecific) {
                                                                        return CryptoUtil.decodePrivateKey(cryptoStructure.withNewHint(StructureHint.EC_PRIVATE_KEY), password, false);
                                                                    }
                                                                    break block65;
                                                                }
                                                                if (cryptoStructure.hint == StructureHint.RSA_PRIVATE_KEY) {
                                                                    if (seq.length < 9) {
                                                                        throw new IllegalArgumentException("ASN.1 SEQUENCE for PKCS#1 RSA private key should contain at least 9 ASN.1 Integers");
                                                                    }
                                                                    int intCount = 0;
                                                                    for (DERObject el2 : seq) {
                                                                        if (intCount >= 9) break;
                                                                        if (!(el2 instanceof DERInteger)) {
                                                                            throw new IllegalArgumentException("Unexpected PKCS#1 RSA private key ASN.1 element found. Expected ASN.1 Integer, found " + el2.getTagAsString());
                                                                        }
                                                                        ++intCount;
                                                                    }
                                                                    BigInteger bigInteger = ((DERInteger)seq[0]).asBigInteger();
                                                                    BigInteger modulus = ((DERInteger)seq[1]).asBigInteger();
                                                                    BigInteger publicExponent = ((DERInteger)seq[2]).asBigInteger();
                                                                    BigInteger privateExponent = ((DERInteger)seq[3]).asBigInteger();
                                                                    BigInteger primeP = ((DERInteger)seq[4]).asBigInteger();
                                                                    BigInteger primeQ = ((DERInteger)seq[5]).asBigInteger();
                                                                    BigInteger primeExponentP = ((DERInteger)seq[6]).asBigInteger();
                                                                    BigInteger primeExponentQ22 = ((DERInteger)seq[7]).asBigInteger();
                                                                    BigInteger crtCoefficient = ((DERInteger)seq[8]).asBigInteger();
                                                                    return new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ22, crtCoefficient);
                                                                }
                                                                if (cryptoStructure.hint == StructureHint.DSA_PRIVATE_KEY) {
                                                                    if (seq.length < 6) {
                                                                        throw new IllegalArgumentException("ASN.1 SEQUENCE for DSA private key should contain at least 6 ASN.1 Integers");
                                                                    }
                                                                    int intCount = 0;
                                                                    for (DERObject el3 : seq) {
                                                                        if (intCount >= 6) break;
                                                                        if (!(el3 instanceof DERInteger)) {
                                                                            throw new IllegalArgumentException("Unexpected DSA private key ASN.1 element found. Expected ASN.1 Integer, found " + el3.getTagAsString());
                                                                        }
                                                                        ++intCount;
                                                                    }
                                                                    BigInteger bigInteger = ((DERInteger)seq[0]).asBigInteger();
                                                                    BigInteger p22 = ((DERInteger)seq[1]).asBigInteger();
                                                                    BigInteger q = ((DERInteger)seq[2]).asBigInteger();
                                                                    BigInteger g = ((DERInteger)seq[3]).asBigInteger();
                                                                    BigInteger pub22 = ((DERInteger)seq[4]).asBigInteger();
                                                                    BigInteger priv = ((DERInteger)seq[5]).asBigInteger();
                                                                    return new DSAPrivateKeySpec(priv, p22, q, g);
                                                                }
                                                                if (cryptoStructure.hint != StructureHint.EC_PRIVATE_KEY) break block66;
                                                                if (seq.length < 3 || !((p22 = seq[0]) instanceof DERInteger)) break block67;
                                                                version = (DERInteger)p22;
                                                                p22 = seq[1];
                                                                if (p22 instanceof DEROctetString) break block68;
                                                            }
                                                            throw new IllegalArgumentException("ASN.1 SEQUENCE for EC private key should contain at least version and privateKey");
                                                        }
                                                        DEROctetString dEROctetString = (DEROctetString)p22;
                                                        if (version.asInt() != 1) {
                                                            throw new IllegalArgumentException("Expected version=1 for ECPrivateKey structure");
                                                        }
                                                        DERObject q = seq[2];
                                                        if (q instanceof DERContextSpecific) {
                                                            DERContextSpecific cs22 = (DERContextSpecific)q;
                                                            try {
                                                                AlgorithmParameters ecParams = AlgorithmParameters.getInstance("EC");
                                                                ecParams.init(cs22.getValue().getEncoded());
                                                                ECParameterSpec ecParamsSpec = ecParams.getParameterSpec(ECParameterSpec.class);
                                                                return new ECPrivateKeySpec(new BigInteger(dEROctetString.getBytes()), ecParamsSpec);
                                                            }
                                                            catch (Exception e22) {
                                                                throw new RuntimeException(e22);
                                                            }
                                                        }
                                                        throw new IllegalArgumentException("Unrecognized ASN.1 structure for EC private key");
                                                    }
                                                    if (cryptoStructure.hint == StructureHint.PKCS8_PRIVATE_KEY) {
                                                        DERObject dERObject4;
                                                        if (seq.length >= 3 && (dERObject4 = seq[0]) instanceof DERInteger) {
                                                            DERInteger version = (DERInteger)dERObject4;
                                                            if (seq[1] instanceof DERSequence && seq[2] instanceof DEROctetString) {
                                                                if (version.asInt() != 0) {
                                                                    throw new IllegalArgumentException("PKCS#8 Private Key with unsupported version: 0x" + version.asBigInteger().toString(16));
                                                                }
                                                                return new PKCS8EncodedKeySpec(cryptoStructure.derData);
                                                            }
                                                        }
                                                        throw new IllegalArgumentException("Unrecognized ASN.1 Structure for PKCS#8 Private Key");
                                                    }
                                                    if (cryptoStructure.hint != StructureHint.PKCS8_ENCRYPTED_PRIVATE_KEY) break block65;
                                                    if (seq.length != 2 || !((cs22 = seq[0]) instanceof DERSequence)) break block69;
                                                    alg = (DERSequence)cs22;
                                                    cs22 = seq[1];
                                                    if (cs22 instanceof DEROctetString) break block70;
                                                }
                                                throw new IllegalArgumentException("Unrecognized ASN.1 Structure for PKCS#8 Encrypted Private Key");
                                            }
                                            DEROctetString dEROctetString = (DEROctetString)cs22;
                                            if (alg.getValues().length < 1 || !((e22 = alg.getValues()[0]) instanceof DERObjectIdentifier)) {
                                                throw new IllegalArgumentException("Unrecognized PKCS#5 algorithm for PKCS#8 Encrypted Private Key");
                                            }
                                            DERObjectIdentifier oid = (DERObjectIdentifier)e22;
                                            if (!"1.2.840.113549.1.5.13".equals(oid.asOid())) break block71;
                                            if (alg.getValues().length < 2 || !((pub22 = alg.getValues()[1]) instanceof DERSequence)) {
                                                throw new IllegalArgumentException("Unrecognized PKCS#5 PBES2 structure for PKCS#8 Encrypted Private Key");
                                            }
                                            DERSequence kdfAndEnc = (DERSequence)pub22;
                                            seq2 = kdfAndEnc.getValues();
                                            if (seq2.length != 2 || !((primeExponentQ22 = seq2[0]) instanceof DERSequence)) break block72;
                                            kdf = (DERSequence)primeExponentQ22;
                                            primeExponentQ22 = seq2[1];
                                            if (primeExponentQ22 instanceof DERSequence) break block73;
                                        }
                                        throw new IllegalArgumentException("Unrecognized PKCS#5 PBES2 structure for PKCS#8 Encrypted Private Key");
                                    }
                                    encScheme = (DERSequence)primeExponentQ22;
                                    if (kdf.getValues().length < 2 || !((dERObject3 = kdf.getValues()[0]) instanceof DERObjectIdentifier)) break block74;
                                    kdfOid = (DERObjectIdentifier)dERObject3;
                                    dERObject3 = kdf.getValues()[1];
                                    if (dERObject3 instanceof DERSequence) break block75;
                                }
                                throw new IllegalArgumentException("Unrecognized PKCS#5 PBES2 KDF structure for PKCS#8 Encrypted Private Key");
                            }
                            DERSequence kdfParams = (DERSequence)dERObject3;
                            if (encScheme.getValues().length < 2 || !((dERObject2 = encScheme.getValues()[0]) instanceof DERObjectIdentifier)) {
                                throw new IllegalArgumentException("Unrecognized PKCS#5 PBES2 Encryption Scheme structure for PKCS#8 Encrypted Private Key");
                            }
                            DERObjectIdentifier encSchemeOid = (DERObjectIdentifier)dERObject2;
                            if (!DERObjectIdentifier.SUPPORTED_PBES2_KDFS.contains(kdfOid.asOid())) {
                                throw new IllegalArgumentException("Unsupported PKCS#5 PBES2 KDF algorithm: " + kdfOid.asOid());
                            }
                            if (!DERObjectIdentifier.SUPPORTED_PBES2_CIPHERS.containsKey(encSchemeOid.asOid())) {
                                throw new IllegalArgumentException("Unsupported PKCS#5 PBES2 Encryption Scheme algorithm: " + encSchemeOid.asOid());
                            }
                            DERSequence prf = null;
                            if (kdfParams.getValues()[2] instanceof DERSequence) {
                                prf = (DERSequence)kdfParams.getValues()[2];
                            } else if (kdfParams.getValues().length >= 4 && kdfParams.getValues()[3] instanceof DERSequence) {
                                prf = (DERSequence)kdfParams.getValues()[3];
                            }
                            if (prf == null || prf.getValues().length < 1 || !((dERObject = prf.getValues()[0]) instanceof DERObjectIdentifier)) {
                                throw new IllegalArgumentException("Unrecognized PKCS#5 PBES2 Pseudo-random function");
                            }
                            DERObjectIdentifier prfOid = (DERObjectIdentifier)dERObject;
                            if (!DERObjectIdentifier.SUPPORTED_PBES2_PRFS.containsKey(prfOid.asOid())) {
                                throw new IllegalArgumentException("Unsupported PKCS#5 PBES2 Pseudo-random function: " + prfOid.asOid());
                            }
                            algName = String.format("PBEWith%sAnd%s", DERObjectIdentifier.SUPPORTED_PBES2_PRFS.get(prfOid.asOid()), DERObjectIdentifier.SUPPORTED_PBES2_CIPHERS.get(encSchemeOid.asOid()));
                            break block76;
                        }
                        if (alg.getValues().length < 2 || !((seq2 = alg.getValues()[0]) instanceof DERObjectIdentifier)) break block77;
                        pbes1Oid = (DERObjectIdentifier)seq2;
                        if (alg.getValues()[1] instanceof DERSequence) break block78;
                    }
                    throw new IllegalArgumentException("Unrecognized PKCS#5 structure for PKCS#8 Encrypted Private Key");
                }
                if (!DERObjectIdentifier.SUPPORTED_PBES1_KDFS.containsKey(pbes1Oid.asOid())) {
                    throw new IllegalArgumentException("Unsupported PKCS#5 PBES1 KDF algorithm: " + pbes1Oid.asOid());
                }
                algName = DERObjectIdentifier.SUPPORTED_PBES1_KDFS.get(pbes1Oid.asOid());
            }
            try {
                Cipher pbeCipher;
                EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(cryptoStructure.derData());
                PBEKeySpec spec = new PBEKeySpec(password == null ? new char[]{} : password);
                try {
                    SecretKeyFactory skf = SecretKeyFactory.getInstance(algName);
                    SecretKey sk = skf.generateSecret(spec);
                    pbeCipher = Cipher.getInstance(algName);
                    pbeCipher.init(2, (Key)sk, epki.getAlgParameters());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalArgumentException("Can't decrypt PKCS#8 encrypted Private Key - unknown algorithm: " + algName, e);
                }
                catch (InvalidKeySpecException e) {
                    throw new IllegalArgumentException("Can't decrypt PKCS#8 encrypted Private Key - corrupted key specification", e);
                }
                catch (NoSuchPaddingException e) {
                    throw new IllegalArgumentException("Can't decrypt PKCS#8 encrypted Private Key - unknown PBE cipher: " + algName, e);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
                    throw new IllegalArgumentException("Can't decrypt PKCS#8 encrypted Private Key - error initializing PBE cipher", e);
                }
                try {
                    return epki.getKeySpec(pbeCipher);
                }
                catch (InvalidKeySpecException e) {
                    throw new IllegalArgumentException("Can't decrypt PKCS#8 encrypted Private Key", e);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't parse EncryptedPrivateKeyInfo from DER structure", e);
            }
        }
        if (cryptoStructure.hint == StructureHint.DER || !firstCheck) {
            throw new IllegalArgumentException("Can't read private key from ASN.1 structure");
        }
        throw new IllegalArgumentException("Can't handle private keys in \"" + cryptoStructure.pemMarker + "\" format");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PrivateKey generatePrivateKey(KeySpec keySpec, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory;
        if (algorithm == null || algorithm.trim().isEmpty()) {
            if (keySpec instanceof DSAPrivateKeySpec) {
                keyFactory = KeyFactory.getInstance("DSA");
                return keyFactory.generatePrivate(keySpec);
            } else if (keySpec instanceof RSAPrivateKeySpec) {
                keyFactory = KeyFactory.getInstance("RSA");
                return keyFactory.generatePrivate(keySpec);
            } else if (keySpec instanceof ECPrivateKeySpec) {
                keyFactory = KeyFactory.getInstance("EC");
                return keyFactory.generatePrivate(keySpec);
            } else {
                if (!(keySpec instanceof PKCS8EncodedKeySpec)) throw new IllegalArgumentException("Can't determine the private key factory to use for DER-encoded private key");
                PKCS8EncodedKeySpec pkcs8 = (PKCS8EncodedKeySpec)keySpec;
                keyFactory = KeyFactory.getInstance(pkcs8.getAlgorithm());
            }
            return keyFactory.generatePrivate(keySpec);
        } else {
            keyFactory = KeyFactory.getInstance(algorithm);
        }
        return keyFactory.generatePrivate(keySpec);
    }

    public static boolean keysMatch(PrivateKey privateKey, PublicKey publicKey) {
        byte[] data = new byte[32];
        new SecureRandom().nextBytes(data);
        Map<String, String> keyToSignature = Map.of("DSA", "SHA256withDSA", "RSA", "SHA256withRSA", "RSASSA-PSS", "RSASSA-PSS");
        try {
            String verifySignatureAlgorithm;
            String signSignatureAlgorithm;
            block23: {
                AlgorithmParameterSpec publicPs;
                block25: {
                    block24: {
                        AlgorithmParameterSpec privatePs;
                        signSignatureAlgorithm = null;
                        verifySignatureAlgorithm = null;
                        if ("EC".equals(privateKey.getAlgorithm())) {
                            int fs2;
                            if (!"EC".equals(publicKey.getAlgorithm())) {
                                throw new IllegalArgumentException("EC Private Key can't be used with non-EC Public Key");
                            }
                            privatePs = ((ECPrivateKey)privateKey).getParams();
                            publicPs = ((ECPublicKey)publicKey).getParams();
                            int fs1 = ((ECParameterSpec)privatePs).getCurve().getField().getFieldSize();
                            if (fs1 != (fs2 = ((ECParameterSpec)publicPs).getCurve().getField().getFieldSize())) {
                                throw new IllegalArgumentException("Can't match EC keys with different field size (" + fs1 + " and " + fs2 + ")");
                            }
                            if (fs1 <= 256) {
                                signSignatureAlgorithm = "SHA256withECDSA";
                                verifySignatureAlgorithm = "SHA256withECDSA";
                            } else if (fs1 <= 384) {
                                signSignatureAlgorithm = "SHA384withECDSA";
                                verifySignatureAlgorithm = "SHA384withECDSA";
                            } else {
                                signSignatureAlgorithm = "SHA512withECDSA";
                                verifySignatureAlgorithm = "SHA512withECDSA";
                            }
                        }
                        if ("EdDSA".equals(privateKey.getAlgorithm())) {
                            if (!"EdDSA".equals(publicKey.getAlgorithm())) {
                                throw new IllegalArgumentException("EdDSA Private Key can't be used with non-EdDSA Public Key");
                            }
                            privatePs = ((EdECPrivateKey)privateKey).getParams();
                            publicPs = ((EdECPublicKey)publicKey).getParams();
                            signSignatureAlgorithm = ((NamedParameterSpec)privatePs).getName();
                            if (!signSignatureAlgorithm.equals(verifySignatureAlgorithm = ((NamedParameterSpec)publicPs).getName())) {
                                throw new IllegalArgumentException("EdDSA keys should use the same algorithm");
                            }
                        }
                        if ("DH".equals(privateKey.getAlgorithm())) {
                            if (!"DH".equals(publicKey.getAlgorithm())) {
                                throw new IllegalArgumentException("DH Private Key can't be used with non-DH Public Key");
                            }
                            return false;
                        }
                        if (!"XDH".equals(privateKey.getAlgorithm())) break block23;
                        if (!"XDH".equals(publicKey.getAlgorithm())) {
                            throw new IllegalArgumentException("XDH Private Key can't be used with non-XDH Public Key");
                        }
                        privatePs = ((XECPrivateKey)privateKey).getParams();
                        publicPs = ((XECPublicKey)publicKey).getParams();
                        if (!(privatePs instanceof NamedParameterSpec)) break block24;
                        NamedParameterSpec privateNamedPs = (NamedParameterSpec)privatePs;
                        if (publicPs instanceof NamedParameterSpec) break block25;
                    }
                    throw new IllegalArgumentException("Expected NamedParameterSpec for XDH keys");
                }
                NamedParameterSpec publicNamedPs = (NamedParameterSpec)publicPs;
                return false;
            }
            if (signSignatureAlgorithm == null) {
                signSignatureAlgorithm = keyToSignature.get(privateKey.getAlgorithm());
            }
            if (signSignatureAlgorithm == null) {
                throw new IllegalArgumentException("Unknown Signature algorithm for private key algorithm \"" + privateKey.getAlgorithm() + "\"");
            }
            Signature signer = Signature.getInstance(signSignatureAlgorithm);
            if (verifySignatureAlgorithm == null) {
                verifySignatureAlgorithm = keyToSignature.get(publicKey.getAlgorithm());
            }
            if (verifySignatureAlgorithm == null) {
                throw new IllegalArgumentException("Unknown Signature algorithm for public key algorithm \"" + publicKey.getAlgorithm() + "\"");
            }
            Signature verifier = Signature.getInstance(verifySignatureAlgorithm);
            if ("RSASSA-PSS".equals(signSignatureAlgorithm)) {
                PSSParameterSpec pss = new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1);
                signer.setParameter(pss);
                verifier.setParameter(pss);
            }
            signer.initSign(privateKey);
            verifier.initVerify(publicKey);
            signer.update(data);
            byte[] signature = signer.sign();
            verifier.update(data);
            return verifier.verify(signature);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            return false;
        }
    }

    public static byte[] encodePem(String marker, byte[] derData) {
        String data = String.format("-----BEGIN %s-----\n", marker) + Base64.getMimeEncoder(64, new byte[]{10}).encodeToString(derData) + String.format("\n-----END %s-----\n", marker);
        return data.getBytes(StandardCharsets.UTF_8);
    }

    public static CryptoStructure decodePemIfNeeded(File pemFile) throws IOException {
        try (PushbackInputStream is = new PushbackInputStream(new FileInputStream(pemFile));){
            int v = is.read();
            boolean looksLikeDer = v == 48;
            is.unread(v);
            if (looksLikeDer) {
                CryptoStructure cryptoStructure = new CryptoStructure(StructureHint.DER, null, is.readAllBytes());
                return cryptoStructure;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = reader.readLine();
            if (line.startsWith("-----BEGIN ") && line.endsWith("-----")) {
                String what = line.substring("-----BEGIN ".length(), line.length() - 5);
                StructureHint hint = StructureHint.from(what);
                if (hint == StructureHint.UNSUPPORTED_PEM) {
                    CryptoStructure cryptoStructure = new CryptoStructure(StructureHint.UNSUPPORTED_PEM, what, null);
                    return cryptoStructure;
                }
                byte[] bytes = CryptoUtil.readPemData(pemFile, reader, line.trim().replace("BEGIN", "END"), what);
                CryptoStructure cryptoStructure = new CryptoStructure(hint, what, bytes);
                return cryptoStructure;
            }
            throw new IOException(String.valueOf(pemFile) + " is neither a proper PEM file nor a ASN.1/DER SEQUENCE");
        }
    }

    private static byte[] readPemData(File pemFile, BufferedReader reader, String endMarker, String type) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if (line.contains("Proc-Type") || line.contains("DEK-Info")) {
                throw new IllegalArgumentException("Legacy encrypted private key \"" + type + "\" is not supported. Please re-encrypt the key using PKCS#8+PKCS#5 format.");
            }
            if (line.equals(endMarker)) {
                return Base64.getMimeDecoder().decode(buf.toString());
            }
            buf.append(line.trim());
        }
        throw new IOException(String.valueOf(pemFile) + " is invalid : No end marker");
    }

    public record CryptoStructure(StructureHint hint, String pemMarker, byte[] derData) {
        public CryptoStructure withNewHint(StructureHint hint) {
            return new CryptoStructure(hint, null, this.derData);
        }
    }

    public static enum StructureHint {
        DER,
        INVALID_PEM,
        UNSUPPORTED_PEM,
        X509_SUBJECT_PUBLIC_KEY_INFO,
        RSA_PUBLIC_KEY,
        RSA_PRIVATE_KEY,
        DSA_PRIVATE_KEY,
        EC_PRIVATE_KEY,
        PKCS8_PRIVATE_KEY,
        PKCS8_ENCRYPTED_PRIVATE_KEY,
        X509_CERTIFICATE;


        public static StructureHint from(String what) {
            return switch (what) {
                case "PUBLIC KEY" -> X509_SUBJECT_PUBLIC_KEY_INFO;
                case "RSA PUBLIC KEY" -> RSA_PUBLIC_KEY;
                case "RSA PRIVATE KEY" -> RSA_PRIVATE_KEY;
                case "DSA PRIVATE KEY" -> DSA_PRIVATE_KEY;
                case "EC PRIVATE KEY" -> EC_PRIVATE_KEY;
                case "PRIVATE KEY" -> PKCS8_PRIVATE_KEY;
                case "ENCRYPTED PRIVATE KEY" -> PKCS8_ENCRYPTED_PRIVATE_KEY;
                case "CERTIFICATE" -> X509_CERTIFICATE;
                default -> UNSUPPORTED_PEM;
            };
        }
    }
}

