/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.object;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.MBeanFeatureInfo;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import org.jolokia.converter.object.ObjectToOpenTypeConverter;
import org.jolokia.core.util.ClassUtil;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;

public class OpenTypeHelper {
    public static final String FIELD_KIND = "kind";
    public static final String FIELD_CLASS = "class";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_DESCRIPTION = "desc";
    public static final String FIELD_ARRAY_PRIMITIVE = "primitive";
    public static final String FIELD_ARRAY_DIMENSION = "dimension";
    public static final String FIELD_ARRAY_ELEMENT_TYPE = "elemType";
    public static final String FIELD_COMPOSITE_ITEMS = "items";
    public static final String FIELD_TABULAR_INDEX = "index";
    public static final String FIELD_TABULAR_ROW_TYPE = "rowType";

    private OpenTypeHelper() {
    }

    public static OpenType<?> findOpenType(Descriptor descriptor) {
        OpenType openType;
        Object v = descriptor == null ? null : descriptor.getFieldValue("openType");
        return v instanceof OpenType ? (openType = (OpenType)v) : null;
    }

    public static Object toJSON(OpenType<?> type, MBeanFeatureInfo featureInfo) {
        if (type instanceof SimpleType) {
            SimpleType simpleType = (SimpleType)type;
            return OpenTypeHelper.toJSON(simpleType, featureInfo);
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return OpenTypeHelper.toJSON(arrayType, featureInfo);
        }
        if (type instanceof CompositeType) {
            CompositeType compositeType = (CompositeType)type;
            return OpenTypeHelper.toJSON(compositeType, featureInfo);
        }
        if (type instanceof TabularType) {
            TabularType tabularType = (TabularType)type;
            return OpenTypeHelper.toJSON(tabularType, featureInfo);
        }
        throw new IllegalArgumentException("Unsupported OpenType: " + type.getClass().getName());
    }

    public static String toJSON(SimpleType<?> simpleType, MBeanFeatureInfo featureInfo) {
        return simpleType.getTypeName();
    }

    public static JSONObject toJSON(ArrayType<?> arrayType, MBeanFeatureInfo featureInfo) {
        JSONObject v = OpenTypeHelper.basicInformation(arrayType);
        v.put(FIELD_KIND, Kind.array.name());
        v.put(FIELD_ARRAY_PRIMITIVE, arrayType.isPrimitiveArray());
        int dimension = arrayType.getDimension();
        v.put(FIELD_ARRAY_DIMENSION, dimension);
        Object elementTypeV = OpenTypeHelper.toJSON(arrayType.getElementOpenType(), null);
        String prefix = "[".repeat(dimension);
        if (v.get(FIELD_TYPE).equals(prefix + "L" + CompositeData.class.getName() + ";") && elementTypeV instanceof JSONObject) {
            Object originalTypeValue;
            JSONObject elementType = (JSONObject)elementTypeV;
            v.put(FIELD_TYPE, prefix + "L" + String.valueOf(elementType.get(FIELD_TYPE)) + ";");
            if (featureInfo != null && featureInfo.getDescriptor() != null && (originalTypeValue = featureInfo.getDescriptor().getFieldValue("originalType")) instanceof String) {
                String originalType = (String)originalTypeValue;
                v.put(FIELD_TYPE, originalType);
            }
        }
        v.put(FIELD_ARRAY_ELEMENT_TYPE, elementTypeV);
        return v;
    }

    public static JSONObject toJSON(CompositeType compositeType, MBeanFeatureInfo featureInfo) {
        JSONObject v = OpenTypeHelper.basicInformation(compositeType);
        v.put(FIELD_KIND, Kind.composite.name());
        JSONObject items = new JSONObject();
        v.put(FIELD_COMPOSITE_ITEMS, items);
        for (String item : compositeType.keySet()) {
            items.put(item, OpenTypeHelper.toJSON(compositeType.getType(item), null));
        }
        return v;
    }

    public static JSONObject toJSON(TabularType tabularType, MBeanFeatureInfo featureInfo) {
        JSONObject v = OpenTypeHelper.basicInformation(tabularType);
        v.put(FIELD_KIND, Kind.tabular.name());
        v.put(FIELD_TABULAR_INDEX, new JSONArray((Collection<?>)tabularType.getIndexNames()));
        v.put(FIELD_TABULAR_ROW_TYPE, OpenTypeHelper.toJSON(tabularType.getRowType(), null));
        return v;
    }

    private static JSONObject basicInformation(OpenType<?> type) {
        JSONObject v = new JSONObject();
        v.put(FIELD_TYPE, type.getTypeName());
        v.put(FIELD_CLASS, type.getClassName());
        v.put(FIELD_DESCRIPTION, type.getDescription());
        return v;
    }

    public static OpenType<?> fromJSON(Object openType) throws OpenDataException {
        JSONObject complexOpenType;
        Object kindV;
        if (openType instanceof String) {
            String simpleOpenType = (String)openType;
            Class cls = ClassUtil.classForName(simpleOpenType, new ClassLoader[0]);
            if (cls != null) {
                return ObjectToOpenTypeConverter.knownSimpleOpenType(cls);
            }
            return null;
        }
        if (openType instanceof JSONObject && (kindV = (complexOpenType = (JSONObject)openType).get(FIELD_KIND)) instanceof String) {
            String kind = (String)kindV;
            Kind k = Kind.from(kind);
            if (k == null || k == Kind.simple) {
                return null;
            }
            return switch (k) {
                case Kind.array -> OpenTypeHelper.fromJSONToArray(complexOpenType);
                case Kind.composite -> OpenTypeHelper.fromJSONToComposite(complexOpenType);
                case Kind.tabular -> OpenTypeHelper.fromJSONToTabular(complexOpenType);
                default -> null;
            };
        }
        return null;
    }

    private static OpenType<?> fromJSONToArray(JSONObject complexOpenType) throws OpenDataException {
        Object classV = complexOpenType.get(FIELD_CLASS);
        if (!(classV instanceof String)) {
            return null;
        }
        Object elemTypeV = complexOpenType.get(FIELD_ARRAY_ELEMENT_TYPE);
        Object dimensionV = complexOpenType.get(FIELD_ARRAY_DIMENSION);
        Object primitiveV = complexOpenType.get(FIELD_ARRAY_PRIMITIVE);
        if (!(elemTypeV instanceof String) && !(elemTypeV instanceof JSONObject)) {
            return null;
        }
        Object elemJsonType = elemTypeV;
        if (dimensionV instanceof Number) {
            Number dimension = (Number)dimensionV;
            if (primitiveV instanceof Boolean) {
                Boolean primitive = (Boolean)primitiveV;
                OpenType<?> elemType = OpenTypeHelper.fromJSON(elemJsonType);
                if (elemType != null) {
                    if (primitive.booleanValue()) {
                        Class cls = ClassUtil.classForName((String)classV, new ClassLoader[0]);
                        return cls == null ? null : ArrayType.getPrimitiveArrayType(cls);
                    }
                    return new ArrayType(dimension.intValue(), elemType);
                }
            }
        }
        return null;
    }

    private static OpenType<?> fromJSONToComposite(JSONObject complexOpenType) throws OpenDataException {
        Object typeV = complexOpenType.get(FIELD_TYPE);
        Object classV = complexOpenType.get(FIELD_CLASS);
        Object descV = complexOpenType.get(FIELD_DESCRIPTION);
        if (!(classV instanceof String) || !CompositeData.class.getName().equals(classV)) {
            return null;
        }
        if (!(typeV instanceof String)) {
            return null;
        }
        Object itemsV = complexOpenType.get(FIELD_COMPOSITE_ITEMS);
        if (itemsV instanceof JSONObject) {
            JSONObject items = (JSONObject)itemsV;
            ArrayList<String> names = new ArrayList<String>(items.size());
            ArrayList<String> descriptions = new ArrayList<String>(items.size());
            ArrayList types = new ArrayList(items.size());
            boolean allTypes = true;
            for (Map.Entry e : items.entrySet()) {
                String key = (String)e.getKey();
                Object value = e.getValue();
                OpenType<?> itemType = OpenTypeHelper.fromJSON(value);
                if (itemType == null) {
                    allTypes = false;
                    break;
                }
                names.add(key);
                descriptions.add(key);
                types.add(itemType);
            }
            if (allTypes) {
                String desc;
                return new CompositeType((String)typeV, descV instanceof String ? (desc = (String)descV) : "", (String[])names.toArray(String[]::new), (String[])descriptions.toArray(String[]::new), (OpenType[])types.toArray(OpenType[]::new));
            }
        }
        return null;
    }

    private static OpenType<?> fromJSONToTabular(JSONObject complexOpenType) throws OpenDataException {
        Object typeV = complexOpenType.get(FIELD_TYPE);
        Object classV = complexOpenType.get(FIELD_CLASS);
        Object descV = complexOpenType.get(FIELD_DESCRIPTION);
        if (!(classV instanceof String) || !TabularData.class.getName().equals(classV)) {
            return null;
        }
        if (!(typeV instanceof String)) {
            return null;
        }
        Object indexV = complexOpenType.get(FIELD_TABULAR_INDEX);
        Object rowTypeV = complexOpenType.get(FIELD_TABULAR_ROW_TYPE);
        if (indexV instanceof JSONArray) {
            JSONArray index = (JSONArray)indexV;
            if (rowTypeV instanceof JSONObject) {
                JSONObject rowType = (JSONObject)rowTypeV;
                ArrayList<String> idx = new ArrayList<String>(index.size());
                boolean isFine = true;
                for (Object item : index) {
                    if (!(item instanceof String)) {
                        isFine = false;
                        break;
                    }
                    idx.add((String)item);
                }
                OpenType<?> compositeRowType = OpenTypeHelper.fromJSON(rowType);
                if (isFine && compositeRowType instanceof CompositeType) {
                    String desc;
                    CompositeType rowCompositeType = (CompositeType)compositeRowType;
                    return new TabularType((String)typeV, descV instanceof String ? (desc = (String)descV) : "", rowCompositeType, (String[])idx.toArray(String[]::new));
                }
            }
        }
        return null;
    }

    public static enum Kind {
        simple,
        array,
        composite,
        tabular;


        public static Kind from(String kind) {
            if (simple.name().equals(kind)) {
                return simple;
            }
            if (array.name().equals(kind)) {
                return array;
            }
            if (composite.name().equals(kind)) {
                return composite;
            }
            if (tabular.name().equals(kind)) {
                return tabular;
            }
            return null;
        }
    }
}

