/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.object;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.jolokia.converter.object.ArrayTypeConverter;
import org.jolokia.converter.object.CompositeTypeConverter;
import org.jolokia.converter.object.Converter;
import org.jolokia.converter.object.OpenTypeConverter;
import org.jolokia.converter.object.SimpleTypeConverter;
import org.jolokia.converter.object.TabularDataConverter;

public class ObjectToOpenTypeConverter
implements Converter<OpenType<?>> {
    private static final Map<String, SimpleType<?>> PRIMITIVE_OPENTYPE_MAP = new HashMap();
    private static final Map<Class<?>, SimpleType<?>> SIMPLE_OPENTYPE_MAP = new HashMap();
    protected final boolean forgiving;
    private final List<OpenTypeConverter<? extends OpenType<?>>> converters;

    public ObjectToOpenTypeConverter(Converter<String> pObjectToObjectConverter, boolean pForgiving) {
        this.converters = Arrays.asList(new SimpleTypeConverter(this, pObjectToObjectConverter), new ArrayTypeConverter(this), new CompositeTypeConverter(this), new TabularDataConverter(this));
        this.forgiving = pForgiving;
    }

    public static SimpleType<?> knownPrimitiveOpenType(String type) {
        return PRIMITIVE_OPENTYPE_MAP.get(type);
    }

    public static SimpleType<?> knownSimpleOpenType(Class<?> cls) {
        return SIMPLE_OPENTYPE_MAP.get(cls);
    }

    @Override
    public Object convert(OpenType<?> pOpenType, Object pValue) {
        if (pValue == null) {
            return null;
        }
        for (OpenTypeConverter<OpenType<?>> converter : this.converters) {
            if (!converter.canConvert(pOpenType)) continue;
            return this.invokeConverter(converter, pOpenType, pValue);
        }
        throw new IllegalArgumentException("Cannot convert " + String.valueOf(pValue) + " to " + String.valueOf(pOpenType) + ": No converter could be found");
    }

    private <T extends OpenType<?>> Object invokeConverter(OpenTypeConverter<T> converter, OpenType<?> pOpenType, Object pValue) {
        OpenType<?> casted = pOpenType;
        return converter.convert(casted, pValue);
    }

    public boolean isForgiving() {
        return this.forgiving;
    }

    static {
        PRIMITIVE_OPENTYPE_MAP.put(Boolean.TYPE.getName(), SimpleType.BOOLEAN);
        PRIMITIVE_OPENTYPE_MAP.put(Character.TYPE.getName(), SimpleType.CHARACTER);
        PRIMITIVE_OPENTYPE_MAP.put(Byte.TYPE.getName(), SimpleType.BYTE);
        PRIMITIVE_OPENTYPE_MAP.put(Short.TYPE.getName(), SimpleType.SHORT);
        PRIMITIVE_OPENTYPE_MAP.put(Integer.TYPE.getName(), SimpleType.INTEGER);
        PRIMITIVE_OPENTYPE_MAP.put(Long.TYPE.getName(), SimpleType.LONG);
        PRIMITIVE_OPENTYPE_MAP.put(Float.TYPE.getName(), SimpleType.FLOAT);
        PRIMITIVE_OPENTYPE_MAP.put(Double.TYPE.getName(), SimpleType.DOUBLE);
        SIMPLE_OPENTYPE_MAP.put(Boolean.TYPE, SimpleType.BOOLEAN);
        SIMPLE_OPENTYPE_MAP.put(Character.TYPE, SimpleType.CHARACTER);
        SIMPLE_OPENTYPE_MAP.put(Byte.TYPE, SimpleType.BYTE);
        SIMPLE_OPENTYPE_MAP.put(Short.TYPE, SimpleType.SHORT);
        SIMPLE_OPENTYPE_MAP.put(Integer.TYPE, SimpleType.INTEGER);
        SIMPLE_OPENTYPE_MAP.put(Long.TYPE, SimpleType.LONG);
        SIMPLE_OPENTYPE_MAP.put(Float.TYPE, SimpleType.FLOAT);
        SIMPLE_OPENTYPE_MAP.put(Double.TYPE, SimpleType.DOUBLE);
        SIMPLE_OPENTYPE_MAP.put(Boolean.class, SimpleType.BOOLEAN);
        SIMPLE_OPENTYPE_MAP.put(Character.class, SimpleType.CHARACTER);
        SIMPLE_OPENTYPE_MAP.put(Byte.class, SimpleType.BYTE);
        SIMPLE_OPENTYPE_MAP.put(Short.class, SimpleType.SHORT);
        SIMPLE_OPENTYPE_MAP.put(Integer.class, SimpleType.INTEGER);
        SIMPLE_OPENTYPE_MAP.put(Long.class, SimpleType.LONG);
        SIMPLE_OPENTYPE_MAP.put(Float.class, SimpleType.FLOAT);
        SIMPLE_OPENTYPE_MAP.put(Double.class, SimpleType.DOUBLE);
        SIMPLE_OPENTYPE_MAP.put(String.class, SimpleType.STRING);
        SIMPLE_OPENTYPE_MAP.put(ObjectName.class, SimpleType.OBJECTNAME);
        SIMPLE_OPENTYPE_MAP.put(Void.class, SimpleType.VOID);
        SIMPLE_OPENTYPE_MAP.put(Date.class, SimpleType.DATE);
        SIMPLE_OPENTYPE_MAP.put(BigInteger.class, SimpleType.BIGINTEGER);
        SIMPLE_OPENTYPE_MAP.put(BigDecimal.class, SimpleType.BIGDECIMAL);
    }
}

