/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.object;

import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.jolokia.converter.object.ObjectToOpenTypeConverter;
import org.jolokia.converter.object.OpenTypeConverter;

class CompositeTypeConverter
extends OpenTypeConverter<CompositeType> {
    private static final Map<String, Object> DEFAULT_PRIMITIVE_VALUES = new HashMap<String, Object>();

    CompositeTypeConverter(ObjectToOpenTypeConverter pObjectToOpenTypeConverter) {
        super(pObjectToOpenTypeConverter);
    }

    @Override
    boolean canConvert(OpenType<?> pType) {
        return pType instanceof CompositeType;
    }

    @Override
    public Object convert(CompositeType pType, Object pValue) {
        Map<String, Object> map = this.toMap(pValue);
        HashMap<String, Object> compositeValues = new HashMap<String, Object>();
        this.fillCompositeWithGivenValues(pType, compositeValues, map);
        this.completeCompositeValuesWithDefaults(pType, compositeValues);
        try {
            return new CompositeDataSupport(pType, compositeValues);
        }
        catch (OpenDataException e) {
            throw new IllegalArgumentException("Can't convert " + pValue.getClass().getName() + " to javax.management.openmbean.CompositeType: " + e.getMessage(), e);
        }
    }

    private void fillCompositeWithGivenValues(CompositeType pType, Map<String, Object> pCompositeValues, Map<String, Object> pMap) {
        for (Map.Entry<String, Object> entry : pMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!pType.containsKey(key)) {
                if (this.isForgiving()) continue;
                throw new IllegalArgumentException("Conversion to CompositeData failed because \"" + key + "\" is not a valid key of the target CompositeType.");
            }
            if (value == null) continue;
            Object convertedValue = this.objectToOpenTypeConverter.convert(pType.getType(key), value);
            pCompositeValues.put(key, convertedValue);
        }
    }

    private void completeCompositeValuesWithDefaults(CompositeType pType, Map<String, Object> pCompositeValues) {
        for (String itemName : pType.keySet()) {
            if (pCompositeValues.containsKey(itemName)) continue;
            Object itemValue = null;
            OpenType<?> itemType = pType.getType(itemName);
            if (itemType instanceof SimpleType) {
                SimpleType sType = (SimpleType)itemType;
                itemValue = DEFAULT_PRIMITIVE_VALUES.get(sType.getClassName());
            }
            pCompositeValues.put(itemName, itemValue);
        }
    }

    static {
        DEFAULT_PRIMITIVE_VALUES.put(Boolean.class.getName(), false);
        DEFAULT_PRIMITIVE_VALUES.put(Character.class.getName(), Character.valueOf('\u0000'));
        DEFAULT_PRIMITIVE_VALUES.put(Byte.class.getName(), 0);
        DEFAULT_PRIMITIVE_VALUES.put(Short.class.getName(), 0);
        DEFAULT_PRIMITIVE_VALUES.put(Integer.class.getName(), 0);
        DEFAULT_PRIMITIVE_VALUES.put(Long.class.getName(), 0L);
        DEFAULT_PRIMITIVE_VALUES.put(Float.class.getName(), Float.valueOf(0.0f));
        DEFAULT_PRIMITIVE_VALUES.put(Double.class.getName(), 0.0);
    }
}

