/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.object;

import java.lang.reflect.Array;
import java.util.Collection;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.jolokia.converter.object.ObjectToOpenTypeConverter;
import org.jolokia.converter.object.OpenTypeConverter;
import org.jolokia.json.JSONArray;

class ArrayTypeConverter
extends OpenTypeConverter<ArrayType<?>> {
    ArrayTypeConverter(ObjectToOpenTypeConverter pObjectToOpenTypeConverter) {
        super(pObjectToOpenTypeConverter);
    }

    @Override
    public boolean canConvert(OpenType<?> pType) {
        return pType instanceof ArrayType;
    }

    @Override
    public Object convert(ArrayType<?> type, Object pValue) {
        Collection jsonArray = pValue instanceof Collection ? (Collection)pValue : (Collection)this.toJSON(pValue, JSONArray.class);
        OpenType<?> elementOpenType = type.getElementOpenType();
        Object valueArray = this.createTargetArray(type, jsonArray.size());
        if (type.getDimension() > 1) {
            try {
                elementOpenType = type.isPrimitiveArray() ? ArrayType.getPrimitiveArrayType(Class.forName(type.getClassName().substring(1))) : new ArrayType(type.getDimension() - 1, elementOpenType);
            }
            catch (ClassNotFoundException | OpenDataException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        int i = 0;
        for (Object element : jsonArray) {
            Array.set(valueArray, i++, this.objectToOpenTypeConverter.convert(elementOpenType, element));
        }
        return valueArray;
    }

    private Object createTargetArray(OpenType<?> pElementType, int pLength) {
        if (pElementType instanceof SimpleType) {
            SimpleType simpleType = (SimpleType)pElementType;
            try {
                Class<?> elementClass = Class.forName(simpleType.getClassName());
                return Array.newInstance(elementClass, pLength);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Can't find class " + pElementType.getClassName() + " for instantiating array: " + e.getMessage(), e);
            }
        }
        if (pElementType instanceof CompositeType) {
            return new CompositeData[pLength];
        }
        if (pElementType instanceof ArrayType) {
            OpenType<?> elementType = ((ArrayType)pElementType).getElementOpenType();
            try {
                Class<?> elementClass;
                if (((ArrayType)pElementType).getDimension() > 1) {
                    elementClass = Class.forName(pElementType.getClassName().substring(1));
                } else {
                    elementClass = Class.forName(elementType.getClassName());
                    if (((ArrayType)pElementType).isPrimitiveArray() && !elementClass.isPrimitive()) {
                        elementClass = this.toPrimitive(elementClass);
                    }
                }
                return Array.newInstance(elementClass, pLength);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Can't find class " + pElementType.getClassName() + " for instantiating array: " + e.getMessage(), e);
            }
        }
        throw new IllegalArgumentException("Unsupported array element type: " + String.valueOf(pElementType));
    }

    private Class<?> toPrimitive(Class<?> elementClass) {
        if (elementClass == Boolean.class) {
            return Boolean.TYPE;
        }
        if (elementClass == Byte.class) {
            return Byte.TYPE;
        }
        if (elementClass == Character.class) {
            return Character.TYPE;
        }
        if (elementClass == Double.class) {
            return Double.TYPE;
        }
        if (elementClass == Float.class) {
            return Float.TYPE;
        }
        if (elementClass == Integer.class) {
            return Integer.TYPE;
        }
        if (elementClass == Long.class) {
            return Long.TYPE;
        }
        if (elementClass == Short.class) {
            return Short.TYPE;
        }
        return null;
    }
}

